/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core;

import com.att.aft.dme2.internal.springframework.core.BridgeMethodResolver;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class MethodIntrospector {
    public static <T> Map<Method, T> selectMethods(Class<?> targetType, final MetadataLookup<T> metadataLookup) {
        final LinkedHashMap methodMap = new LinkedHashMap();
        LinkedHashSet handlerTypes = new LinkedHashSet();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(targetType)) {
            handlerTypes.add(targetType);
            specificHandlerType = targetType;
        }
        handlerTypes.addAll(Arrays.asList(targetType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            final Class targetClass = specificHandlerType != null ? specificHandlerType : clazz;
            ReflectionUtils.doWithMethods(clazz, new ReflectionUtils.MethodCallback(){

                @Override
                public void doWith(Method method) {
                    Method bridgedMethod;
                    Method specificMethod = ClassUtils.getMostSpecificMethod(method, targetClass);
                    Object result = metadataLookup.inspect(specificMethod);
                    if (result != null && ((bridgedMethod = BridgeMethodResolver.findBridgedMethod(specificMethod)) == specificMethod || metadataLookup.inspect(bridgedMethod) == null)) {
                        methodMap.put(specificMethod, result);
                    }
                }
            }, ReflectionUtils.USER_DECLARED_METHODS);
        }
        return methodMap;
    }

    public static Set<Method> selectMethods(Class<?> targetType, final ReflectionUtils.MethodFilter methodFilter) {
        return MethodIntrospector.selectMethods(targetType, new MetadataLookup<Boolean>(){

            @Override
            public Boolean inspect(Method method) {
                return methodFilter.matches(method) ? Boolean.TRUE : null;
            }
        }).keySet();
    }

    public static Method selectInvocableMethod(Method method, Class<?> targetType) {
        if (method.getDeclaringClass().isAssignableFrom(targetType)) {
            return method;
        }
        try {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (Class<?> ifc : targetType.getInterfaces()) {
                try {
                    return ifc.getMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            return targetType.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(String.format("Need to invoke method '%s' declared on target class '%s', but not found in any interface(s) of the exposed proxy type. Either pull the method up to an interface or switch to CGLIB proxies by enforcing proxy-target-class mode in your configuration.", method.getName(), method.getDeclaringClass().getSimpleName()));
        }
    }

    public static interface MetadataLookup<T> {
        public T inspect(Method var1);
    }
}

