/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public abstract class SpringProperties {
    private static final String PROPERTIES_RESOURCE_LOCATION = "spring.properties";
    private static final Log logger;
    private static final Properties localProperties;

    public static void setProperty(String key, String value) {
        if (value != null) {
            localProperties.setProperty(key, value);
        } else {
            localProperties.remove(key);
        }
    }

    public static String getProperty(String key) {
        String value;
        block3: {
            value = localProperties.getProperty(key);
            if (value == null) {
                try {
                    value = System.getProperty(key);
                }
                catch (Throwable ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Could not retrieve system property '" + key + "': " + ex);
                }
            }
        }
        return value;
    }

    public static void setFlag(String key) {
        localProperties.put(key, Boolean.TRUE.toString());
    }

    public static boolean getFlag(String key) {
        return Boolean.parseBoolean(SpringProperties.getProperty(key));
    }

    static {
        block5: {
            logger = LogFactory.getLog(SpringProperties.class);
            localProperties = new Properties();
            try {
                URL url;
                ClassLoader cl = SpringProperties.class.getClassLoader();
                URL uRL = url = cl != null ? cl.getResource(PROPERTIES_RESOURCE_LOCATION) : ClassLoader.getSystemResource(PROPERTIES_RESOURCE_LOCATION);
                if (url == null) break block5;
                logger.info("Found 'spring.properties' file in local classpath");
                InputStream is = url.openStream();
                try {
                    localProperties.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                if (!logger.isInfoEnabled()) break block5;
                logger.info("Could not load 'spring.properties' file from local classpath: " + ex);
            }
        }
    }
}

