/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.convert.converter;

import com.att.aft.dme2.internal.springframework.core.convert.ConversionService;
import com.att.aft.dme2.internal.springframework.core.convert.converter.Converter;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.comparator.ComparableComparator;
import java.util.Comparator;
import java.util.Map;

public class ConvertingComparator<S, T>
implements Comparator<S> {
    private Comparator<T> comparator;
    private Converter<S, T> converter;

    public ConvertingComparator(Converter<S, T> converter) {
        this(ComparableComparator.INSTANCE, converter);
    }

    public ConvertingComparator(Comparator<T> comparator, Converter<S, T> converter) {
        Assert.notNull(comparator, "Comparator must not be null");
        Assert.notNull(converter, "Converter must not be null");
        this.comparator = comparator;
        this.converter = converter;
    }

    public ConvertingComparator(Comparator<T> comparator, ConversionService conversionService, Class<? extends T> targetType) {
        this(comparator, new ConversionServiceConverter(conversionService, targetType));
    }

    @Override
    public int compare(S o1, S o2) {
        T c1 = this.converter.convert(o1);
        T c2 = this.converter.convert(o2);
        return this.comparator.compare(c1, c2);
    }

    public static <K, V> ConvertingComparator<Map.Entry<K, V>, K> mapEntryKeys(Comparator<K> comparator) {
        return new ConvertingComparator(comparator, new Converter<Map.Entry<K, V>, K>(){

            @Override
            public K convert(Map.Entry<K, V> source) {
                return source.getKey();
            }
        });
    }

    public static <K, V> ConvertingComparator<Map.Entry<K, V>, V> mapEntryValues(Comparator<V> comparator) {
        return new ConvertingComparator(comparator, new Converter<Map.Entry<K, V>, V>(){

            @Override
            public V convert(Map.Entry<K, V> source) {
                return source.getValue();
            }
        });
    }

    private static class ConversionServiceConverter<S, T>
    implements Converter<S, T> {
        private final ConversionService conversionService;
        private final Class<? extends T> targetType;

        public ConversionServiceConverter(ConversionService conversionService, Class<? extends T> targetType) {
            Assert.notNull(conversionService, "ConversionService must not be null");
            Assert.notNull(targetType, "TargetType must not be null");
            this.conversionService = conversionService;
            this.targetType = targetType;
        }

        @Override
        public T convert(S source) {
            return this.conversionService.convert(source, this.targetType);
        }
    }
}

