/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.convert.support;

import com.att.aft.dme2.internal.springframework.core.convert.converter.Converter;
import com.att.aft.dme2.internal.springframework.core.convert.converter.ConverterFactory;
import com.att.aft.dme2.internal.springframework.core.convert.converter.ConverterRegistry;
import com.att.aft.dme2.internal.springframework.core.convert.converter.GenericConverter;
import java.util.Set;

public abstract class ConversionServiceFactory {
    public static void registerConverters(Set<?> converters, ConverterRegistry registry) {
        if (converters != null) {
            for (Object converter : converters) {
                if (converter instanceof GenericConverter) {
                    registry.addConverter((GenericConverter)converter);
                    continue;
                }
                if (converter instanceof Converter) {
                    registry.addConverter((Converter)converter);
                    continue;
                }
                if (converter instanceof ConverterFactory) {
                    registry.addConverterFactory((ConverterFactory)converter);
                    continue;
                }
                throw new IllegalArgumentException("Each converter object must implement one of the Converter, ConverterFactory, or GenericConverter interfaces");
            }
        }
    }
}

