/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.convert.support;

import com.att.aft.dme2.internal.springframework.core.convert.ConversionService;
import com.att.aft.dme2.internal.springframework.core.convert.TypeDescriptor;
import com.att.aft.dme2.internal.springframework.core.convert.converter.ConditionalGenericConverter;
import com.att.aft.dme2.internal.springframework.core.convert.converter.GenericConverter;
import com.att.aft.dme2.internal.springframework.lang.UsesJava8;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

@UsesJava8
final class ObjectToOptionalConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ObjectToOptionalConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Optional.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.getResolvableType() != null) {
            return this.conversionService.canConvert(sourceType, new GenericTypeDescriptor(targetType));
        }
        return true;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return Optional.empty();
        }
        if (source instanceof Optional) {
            return source;
        }
        if (targetType.getResolvableType() == null) {
            return Optional.of(source);
        }
        Object target = this.conversionService.convert(source, sourceType, new GenericTypeDescriptor(targetType));
        return Optional.ofNullable(target);
    }

    private static class GenericTypeDescriptor
    extends TypeDescriptor {
        public GenericTypeDescriptor(TypeDescriptor typeDescriptor) {
            super(typeDescriptor.getResolvableType().getGeneric(0), null, typeDescriptor.getAnnotations());
        }
    }
}

