/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.env;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.core.env.PropertySource;
import com.att.aft.dme2.internal.springframework.core.env.PropertySources;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MutablePropertySources
implements PropertySources {
    private final Log logger;
    private final List<PropertySource<?>> propertySourceList = new CopyOnWriteArrayList();

    public MutablePropertySources() {
        this.logger = LogFactory.getLog(this.getClass());
    }

    public MutablePropertySources(PropertySources propertySources) {
        this();
        for (PropertySource propertySource : propertySources) {
            this.addLast(propertySource);
        }
    }

    MutablePropertySources(Log logger) {
        this.logger = logger;
    }

    @Override
    public boolean contains(String name) {
        return this.propertySourceList.contains(PropertySource.named(name));
    }

    @Override
    public PropertySource<?> get(String name) {
        int index = this.propertySourceList.indexOf(PropertySource.named(name));
        return index != -1 ? this.propertySourceList.get(index) : null;
    }

    @Override
    public Iterator<PropertySource<?>> iterator() {
        return this.propertySourceList.iterator();
    }

    public void addFirst(PropertySource<?> propertySource) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Adding [%s] PropertySource with highest search precedence", propertySource.getName()));
        }
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(0, propertySource);
    }

    public void addLast(PropertySource<?> propertySource) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Adding [%s] PropertySource with lowest search precedence", propertySource.getName()));
        }
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(propertySource);
    }

    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Adding [%s] PropertySource with search precedence immediately higher than [%s]", propertySource.getName(), relativePropertySourceName));
        }
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        this.removeIfPresent(propertySource);
        int index = this.assertPresentAndGetIndex(relativePropertySourceName);
        this.addAtIndex(index, propertySource);
    }

    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Adding [%s] PropertySource with search precedence immediately lower than [%s]", propertySource.getName(), relativePropertySourceName));
        }
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        this.removeIfPresent(propertySource);
        int index = this.assertPresentAndGetIndex(relativePropertySourceName);
        this.addAtIndex(index + 1, propertySource);
    }

    public int precedenceOf(PropertySource<?> propertySource) {
        return this.propertySourceList.indexOf(propertySource);
    }

    public PropertySource<?> remove(String name) {
        int index;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Removing [%s] PropertySource", name));
        }
        return (index = this.propertySourceList.indexOf(PropertySource.named(name))) != -1 ? this.propertySourceList.remove(index) : null;
    }

    public void replace(String name, PropertySource<?> propertySource) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Replacing [%s] PropertySource with [%s]", name, propertySource.getName()));
        }
        int index = this.assertPresentAndGetIndex(name);
        this.propertySourceList.set(index, propertySource);
    }

    public int size() {
        return this.propertySourceList.size();
    }

    public String toString() {
        Object[] names = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            names[i] = this.propertySourceList.get(i).getName();
        }
        return String.format("[%s]", StringUtils.arrayToCommaDelimitedString(names));
    }

    protected void assertLegalRelativeAddition(String relativePropertySourceName, PropertySource<?> propertySource) {
        String newPropertySourceName = propertySource.getName();
        if (relativePropertySourceName.equals(newPropertySourceName)) {
            throw new IllegalArgumentException(String.format("PropertySource named [%s] cannot be added relative to itself", newPropertySourceName));
        }
    }

    protected void removeIfPresent(PropertySource<?> propertySource) {
        this.propertySourceList.remove(propertySource);
    }

    private void addAtIndex(int index, PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(index, propertySource);
    }

    private int assertPresentAndGetIndex(String name) {
        int index = this.propertySourceList.indexOf(PropertySource.named(name));
        if (index == -1) {
            throw new IllegalArgumentException(String.format("PropertySource named [%s] does not exist", name));
        }
        return index;
    }
}

