/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.serializer.support;

import com.att.aft.dme2.internal.springframework.core.convert.converter.Converter;
import com.att.aft.dme2.internal.springframework.core.serializer.DefaultSerializer;
import com.att.aft.dme2.internal.springframework.core.serializer.Serializer;
import com.att.aft.dme2.internal.springframework.core.serializer.support.SerializationFailedException;
import com.att.aft.dme2.internal.springframework.util.Assert;
import java.io.ByteArrayOutputStream;

public class SerializingConverter
implements Converter<Object, byte[]> {
    private final Serializer<Object> serializer;

    public SerializingConverter() {
        this.serializer = new DefaultSerializer();
    }

    public SerializingConverter(Serializer<Object> serializer) {
        Assert.notNull(serializer, "Serializer must not be null");
        this.serializer = serializer;
    }

    @Override
    public byte[] convert(Object source) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(1024);
        try {
            this.serializer.serialize(source, byteStream);
            return byteStream.toByteArray();
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to serialize object using " + this.serializer.getClass().getSimpleName(), ex);
        }
    }
}

