/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.style;

import com.att.aft.dme2.internal.springframework.core.style.ToStringStyler;
import com.att.aft.dme2.internal.springframework.core.style.ValueStyler;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.ObjectUtils;

public class DefaultToStringStyler
implements ToStringStyler {
    private final ValueStyler valueStyler;

    public DefaultToStringStyler(ValueStyler valueStyler) {
        Assert.notNull(valueStyler, "ValueStyler must not be null");
        this.valueStyler = valueStyler;
    }

    protected final ValueStyler getValueStyler() {
        return this.valueStyler;
    }

    @Override
    public void styleStart(StringBuilder buffer, Object obj) {
        if (!obj.getClass().isArray()) {
            buffer.append('[').append(ClassUtils.getShortName(obj.getClass()));
            this.styleIdentityHashCode(buffer, obj);
        } else {
            buffer.append('[');
            this.styleIdentityHashCode(buffer, obj);
            buffer.append(' ');
            this.styleValue(buffer, obj);
        }
    }

    private void styleIdentityHashCode(StringBuilder buffer, Object obj) {
        buffer.append('@');
        buffer.append(ObjectUtils.getIdentityHexString(obj));
    }

    @Override
    public void styleEnd(StringBuilder buffer, Object o) {
        buffer.append(']');
    }

    @Override
    public void styleField(StringBuilder buffer, String fieldName, Object value) {
        this.styleFieldStart(buffer, fieldName);
        this.styleValue(buffer, value);
        this.styleFieldEnd(buffer, fieldName);
    }

    protected void styleFieldStart(StringBuilder buffer, String fieldName) {
        buffer.append(' ').append(fieldName).append(" = ");
    }

    protected void styleFieldEnd(StringBuilder buffer, String fieldName) {
    }

    @Override
    public void styleValue(StringBuilder buffer, Object value) {
        buffer.append(this.valueStyler.style(value));
    }

    @Override
    public void styleFieldSeparator(StringBuilder buffer) {
        buffer.append(',');
    }
}

