/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.type.classreading;

import com.att.aft.dme2.internal.springframework.asm.AnnotationVisitor;
import com.att.aft.dme2.internal.springframework.asm.MethodVisitor;
import com.att.aft.dme2.internal.springframework.asm.Type;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationAttributes;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationUtils;
import com.att.aft.dme2.internal.springframework.core.type.AnnotationMetadata;
import com.att.aft.dme2.internal.springframework.core.type.MethodMetadata;
import com.att.aft.dme2.internal.springframework.core.type.classreading.AnnotationAttributesReadingVisitor;
import com.att.aft.dme2.internal.springframework.core.type.classreading.AnnotationReadingVisitorUtils;
import com.att.aft.dme2.internal.springframework.core.type.classreading.ClassMetadataReadingVisitor;
import com.att.aft.dme2.internal.springframework.core.type.classreading.MethodMetadataReadingVisitor;
import com.att.aft.dme2.internal.springframework.util.LinkedMultiValueMap;
import com.att.aft.dme2.internal.springframework.util.MultiValueMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AnnotationMetadataReadingVisitor
extends ClassMetadataReadingVisitor
implements AnnotationMetadata {
    protected final ClassLoader classLoader;
    protected final Set<String> annotationSet = new LinkedHashSet<String>(4);
    protected final Map<String, Set<String>> metaAnnotationMap = new LinkedHashMap<String, Set<String>>(4);
    protected final LinkedMultiValueMap<String, AnnotationAttributes> attributesMap = new LinkedMultiValueMap(4);
    protected final Set<MethodMetadata> methodMetadataSet = new LinkedHashSet<MethodMetadata>(4);

    public AnnotationMetadataReadingVisitor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x40) != 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        return new MethodMetadataReadingVisitor(name, access, this.getClassName(), Type.getReturnType(desc).getClassName(), this.classLoader, this.methodMetadataSet);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType(desc).getClassName();
        this.annotationSet.add(className);
        return new AnnotationAttributesReadingVisitor(className, this.attributesMap, this.metaAnnotationMap, this.classLoader);
    }

    @Override
    public Set<String> getAnnotationTypes() {
        return this.annotationSet;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationName) {
        return this.metaAnnotationMap.get(annotationName);
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return this.annotationSet.contains(annotationName);
    }

    @Override
    public boolean hasMetaAnnotation(String metaAnnotationType) {
        Collection<Set<String>> allMetaTypes = this.metaAnnotationMap.values();
        for (Set<String> metaTypes : allMetaTypes) {
            if (!metaTypes.contains(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnnotated(String annotationName) {
        return !AnnotationUtils.isInJavaLangAnnotationPackage(annotationName) && this.attributesMap.containsKey(annotationName);
    }

    public AnnotationAttributes getAnnotationAttributes(String annotationName) {
        return this.getAnnotationAttributes(annotationName, false);
    }

    public AnnotationAttributes getAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        AnnotationAttributes raw = AnnotationReadingVisitorUtils.getMergedAnnotationAttributes(this.attributesMap, this.metaAnnotationMap, annotationName);
        return AnnotationReadingVisitorUtils.convertClassValues("class '" + this.getClassName() + "'", this.classLoader, raw, classValuesAsString);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName) {
        return this.getAllAnnotationAttributes(annotationName, false);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationName, boolean classValuesAsString) {
        LinkedMultiValueMap<String, Object> allAttributes = new LinkedMultiValueMap<String, Object>();
        Object attributes = this.attributesMap.get(annotationName);
        if (attributes == null) {
            return null;
        }
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            AnnotationAttributes raw = (AnnotationAttributes)iterator.next();
            for (Map.Entry entry : AnnotationReadingVisitorUtils.convertClassValues("class '" + this.getClassName() + "'", this.classLoader, raw, classValuesAsString).entrySet()) {
                allAttributes.add((String)entry.getKey(), entry.getValue());
            }
        }
        return allAttributes;
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationName) {
        for (MethodMetadata methodMetadata : this.methodMetadataSet) {
            if (!methodMetadata.isAnnotated(annotationName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>(4);
        for (MethodMetadata methodMetadata : this.methodMetadataSet) {
            if (!methodMetadata.isAnnotated(annotationName)) continue;
            annotatedMethods.add(methodMetadata);
        }
        return annotatedMethods;
    }
}

