/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.type.classreading;

import com.att.aft.dme2.internal.springframework.core.io.DefaultResourceLoader;
import com.att.aft.dme2.internal.springframework.core.io.Resource;
import com.att.aft.dme2.internal.springframework.core.io.ResourceLoader;
import com.att.aft.dme2.internal.springframework.core.type.classreading.MetadataReader;
import com.att.aft.dme2.internal.springframework.core.type.classreading.MetadataReaderFactory;
import com.att.aft.dme2.internal.springframework.core.type.classreading.SimpleMetadataReader;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.io.IOException;

public class SimpleMetadataReaderFactory
implements MetadataReaderFactory {
    private final ResourceLoader resourceLoader;

    public SimpleMetadataReaderFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ClassLoader classLoader) {
        this.resourceLoader = classLoader != null ? new DefaultResourceLoader(classLoader) : new DefaultResourceLoader();
    }

    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public MetadataReader getMetadataReader(String className) throws IOException {
        int lastDotIndex;
        String resourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(className) + ".class";
        Resource resource = this.resourceLoader.getResource(resourcePath);
        if (!resource.exists() && (lastDotIndex = className.lastIndexOf(46)) != -1) {
            String innerClassName = className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1);
            String innerClassResourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(innerClassName) + ".class";
            Resource innerClassResource = this.resourceLoader.getResource(innerClassResourcePath);
            if (innerClassResource.exists()) {
                resource = innerClassResource;
            }
        }
        return this.getMetadataReader(resource);
    }

    @Override
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        return new SimpleMetadataReader(resource, this.resourceLoader.getClassLoader());
    }
}

