/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.core.type.filter;

import com.att.aft.dme2.internal.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;

public class AssignableTypeFilter
extends AbstractTypeHierarchyTraversingFilter {
    private final Class<?> targetType;

    public AssignableTypeFilter(Class<?> targetType) {
        super(true, true);
        this.targetType = targetType;
    }

    @Override
    protected boolean matchClassName(String className) {
        return this.targetType.getName().equals(className);
    }

    @Override
    protected Boolean matchSuperClass(String superClassName) {
        return this.matchTargetType(superClassName);
    }

    @Override
    protected Boolean matchInterface(String interfaceName) {
        return this.matchTargetType(interfaceName);
    }

    protected Boolean matchTargetType(String typeName) {
        if (this.targetType.getName().equals(typeName)) {
            return true;
        }
        if (Object.class.getName().equals(typeName)) {
            return false;
        }
        if (typeName.startsWith("java")) {
            try {
                Class<?> clazz = ClassUtils.forName(typeName, this.getClass().getClassLoader());
                return this.targetType.isAssignableFrom(clazz);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

