/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.ejb.access;

import com.att.aft.dme2.internal.aopalliance.intercept.MethodInvocation;
import com.att.aft.dme2.internal.springframework.ejb.access.AbstractSlsbInvokerInterceptor;
import com.att.aft.dme2.internal.springframework.ejb.access.EjbAccessException;
import com.att.aft.dme2.internal.springframework.remoting.RemoteConnectFailureException;
import com.att.aft.dme2.internal.springframework.remoting.RemoteLookupFailureException;
import com.att.aft.dme2.internal.springframework.remoting.rmi.RmiClientInterceptorUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public abstract class AbstractRemoteSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    private Class<?> homeInterface;
    private boolean refreshHomeOnConnectFailure = false;
    private volatile boolean homeAsComponent = false;

    public void setHomeInterface(Class<?> homeInterface) {
        if (homeInterface != null && !homeInterface.isInterface()) {
            throw new IllegalArgumentException("Home interface class [" + homeInterface.getClass() + "] is not an interface");
        }
        this.homeInterface = homeInterface;
    }

    public void setRefreshHomeOnConnectFailure(boolean refreshHomeOnConnectFailure) {
        this.refreshHomeOnConnectFailure = refreshHomeOnConnectFailure;
    }

    @Override
    protected boolean isHomeRefreshable() {
        return this.refreshHomeOnConnectFailure;
    }

    @Override
    protected Object lookup() throws NamingException {
        Object homeObject = super.lookup();
        if (this.homeInterface != null) {
            try {
                homeObject = PortableRemoteObject.narrow((Object)homeObject, this.homeInterface);
            }
            catch (ClassCastException ex) {
                throw new RemoteLookupFailureException("Could not narrow EJB home stub to home interface [" + this.homeInterface.getName() + "]", ex);
            }
        }
        return homeObject;
    }

    @Override
    protected Method getCreateMethod(Object home) throws EjbAccessException {
        if (this.homeAsComponent) {
            return null;
        }
        if (!(home instanceof EJBHome)) {
            this.homeAsComponent = true;
            return null;
        }
        return super.getCreateMethod(home);
    }

    @Override
    public Object invokeInContext(MethodInvocation invocation) throws Throwable {
        try {
            return this.doInvoke(invocation);
        }
        catch (RemoteConnectFailureException ex) {
            return this.handleRemoteConnectFailure(invocation, ex);
        }
        catch (RemoteException ex) {
            if (this.isConnectFailure(ex)) {
                return this.handleRemoteConnectFailure(invocation, ex);
            }
            throw ex;
        }
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return RmiClientInterceptorUtils.isConnectFailure(ex);
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex) throws Throwable {
        if (this.refreshHomeOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying", ex);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying");
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex;
    }

    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        try {
            this.refreshHome();
        }
        catch (NamingException ex) {
            throw new RemoteLookupFailureException("Failed to locate remote EJB [" + this.getJndiName() + "]", ex);
        }
        return this.doInvoke(invocation);
    }

    protected abstract Object doInvoke(MethodInvocation var1) throws Throwable;

    protected Object newSessionBeanInstance() throws NamingException, InvocationTargetException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to create reference to remote EJB");
        }
        Object ejbInstance = this.create();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Obtained reference to remote EJB: " + ejbInstance);
        }
        return ejbInstance;
    }

    protected void removeSessionBeanInstance(EJBObject ejb) {
        if (ejb != null && !this.homeAsComponent) {
            try {
                ejb.remove();
            }
            catch (Throwable ex) {
                this.logger.warn("Could not invoke 'remove' on remote EJB proxy", ex);
            }
        }
    }
}

