/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.ejb.interceptor;

import com.att.aft.dme2.internal.springframework.beans.factory.BeanFactory;
import com.att.aft.dme2.internal.springframework.beans.factory.access.BeanFactoryLocator;
import com.att.aft.dme2.internal.springframework.beans.factory.access.BeanFactoryReference;
import com.att.aft.dme2.internal.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import com.att.aft.dme2.internal.springframework.context.ApplicationContext;
import com.att.aft.dme2.internal.springframework.context.access.ContextSingletonBeanFactoryLocator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJBException;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;

public class SpringBeanAutowiringInterceptor {
    private final Map<Object, BeanFactoryReference> beanFactoryReferences = new WeakHashMap<Object, BeanFactoryReference>();

    @PostConstruct
    @PostActivate
    public void autowireBean(InvocationContext invocationContext) {
        this.doAutowireBean(invocationContext.getTarget());
        try {
            invocationContext.proceed();
        }
        catch (RuntimeException ex) {
            this.doReleaseBean(invocationContext.getTarget());
            throw ex;
        }
        catch (Error err) {
            this.doReleaseBean(invocationContext.getTarget());
            throw err;
        }
        catch (Exception ex) {
            this.doReleaseBean(invocationContext.getTarget());
            throw new EJBException(ex);
        }
    }

    protected void doAutowireBean(Object target) {
        AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
        this.configureBeanPostProcessor(bpp, target);
        bpp.setBeanFactory(this.getBeanFactory(target));
        bpp.processInjection(target);
    }

    protected void configureBeanPostProcessor(AutowiredAnnotationBeanPostProcessor processor, Object target) {
    }

    protected BeanFactory getBeanFactory(Object target) {
        BeanFactory factory = this.getBeanFactoryReference(target).getFactory();
        if (factory instanceof ApplicationContext) {
            factory = ((ApplicationContext)factory).getAutowireCapableBeanFactory();
        }
        return factory;
    }

    protected BeanFactoryReference getBeanFactoryReference(Object target) {
        String key = this.getBeanFactoryLocatorKey(target);
        BeanFactoryReference ref = this.getBeanFactoryLocator(target).useBeanFactory(key);
        this.beanFactoryReferences.put(target, ref);
        return ref;
    }

    protected BeanFactoryLocator getBeanFactoryLocator(Object target) {
        return ContextSingletonBeanFactoryLocator.getInstance();
    }

    protected String getBeanFactoryLocatorKey(Object target) {
        return null;
    }

    @PreDestroy
    @PrePassivate
    public void releaseBean(InvocationContext invocationContext) {
        this.doReleaseBean(invocationContext.getTarget());
        try {
            invocationContext.proceed();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    protected void doReleaseBean(Object target) {
        BeanFactoryReference ref = this.beanFactoryReferences.remove(target);
        if (ref != null) {
            ref.release();
        }
    }
}

