/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.expression.spel.ast;

import com.att.aft.dme2.internal.springframework.expression.AccessException;
import com.att.aft.dme2.internal.springframework.expression.BeanResolver;
import com.att.aft.dme2.internal.springframework.expression.EvaluationException;
import com.att.aft.dme2.internal.springframework.expression.TypedValue;
import com.att.aft.dme2.internal.springframework.expression.spel.ExpressionState;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelEvaluationException;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelMessage;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.SpelNodeImpl;

public class BeanReference
extends SpelNodeImpl {
    private static final String FACTORY_BEAN_PREFIX = "&";
    private final String beanName;

    public BeanReference(int pos, String beanName) {
        super(pos, new SpelNodeImpl[0]);
        this.beanName = beanName;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        BeanResolver beanResolver = state.getEvaluationContext().getBeanResolver();
        if (beanResolver == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.NO_BEAN_RESOLVER_REGISTERED, this.beanName);
        }
        try {
            return new TypedValue(beanResolver.resolve(state.getEvaluationContext(), this.beanName));
        }
        catch (AccessException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_BEAN_RESOLUTION, this.beanName, ex.getMessage());
        }
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        if (!this.beanName.startsWith(FACTORY_BEAN_PREFIX)) {
            sb.append("@");
        }
        if (!this.beanName.contains(".")) {
            sb.append(this.beanName);
        } else {
            sb.append("'").append(this.beanName).append("'");
        }
        return sb.toString();
    }
}

