/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.expression.spel.ast;

import com.att.aft.dme2.internal.springframework.asm.MethodVisitor;
import com.att.aft.dme2.internal.springframework.expression.spel.CodeFlow;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.Literal;
import com.att.aft.dme2.internal.springframework.expression.spel.support.BooleanTypedValue;

public class BooleanLiteral
extends Literal {
    private final BooleanTypedValue value;

    public BooleanLiteral(String payload, int pos, boolean value) {
        super(payload, pos);
        this.value = BooleanTypedValue.forValue(value);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        if (this.value == BooleanTypedValue.TRUE) {
            mv.visitLdcInsn(1);
        } else {
            mv.visitLdcInsn(0);
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

