/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.expression.spel.ast;

import com.att.aft.dme2.internal.springframework.asm.MethodVisitor;
import com.att.aft.dme2.internal.springframework.expression.TypedValue;
import com.att.aft.dme2.internal.springframework.expression.spel.CodeFlow;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.Literal;

public class IntLiteral
extends Literal {
    private final TypedValue value;

    public IntLiteral(String payload, int pos, int value) {
        super(payload, pos);
        this.value = new TypedValue(value);
        this.exitTypeDescriptor = "I";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        int intValue = (Integer)this.value.getValue();
        if (intValue == -1) {
            mv.visitInsn(2);
        } else if (intValue >= 0 && intValue < 6) {
            mv.visitInsn(3 + intValue);
        } else {
            mv.visitLdcInsn(intValue);
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

