/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.expression.spel.ast;

import com.att.aft.dme2.internal.springframework.expression.TypedValue;
import com.att.aft.dme2.internal.springframework.expression.spel.ExpressionState;
import com.att.aft.dme2.internal.springframework.expression.spel.InternalParseException;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelEvaluationException;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelMessage;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelParseException;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.FloatLiteral;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.IntLiteral;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.LongLiteral;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.RealLiteral;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.SpelNodeImpl;

public abstract class Literal
extends SpelNodeImpl {
    private final String originalValue;

    public Literal(String originalValue, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.originalValue = originalValue;
    }

    public final String getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public final TypedValue getValueInternal(ExpressionState state) throws SpelEvaluationException {
        return this.getLiteralValue();
    }

    public String toString() {
        return this.getLiteralValue().getValue().toString();
    }

    @Override
    public String toStringAST() {
        return this.toString();
    }

    public abstract TypedValue getLiteralValue();

    public static Literal getIntLiteral(String numberToken, int pos, int radix) {
        try {
            int value = Integer.parseInt(numberToken, radix);
            return new IntLiteral(numberToken, pos, value);
        }
        catch (NumberFormatException ex) {
            throw new InternalParseException(new SpelParseException(pos >> 16, (Throwable)ex, SpelMessage.NOT_AN_INTEGER, numberToken));
        }
    }

    public static Literal getLongLiteral(String numberToken, int pos, int radix) {
        try {
            long value = Long.parseLong(numberToken, radix);
            return new LongLiteral(numberToken, pos, value);
        }
        catch (NumberFormatException ex) {
            throw new InternalParseException(new SpelParseException(pos >> 16, (Throwable)ex, SpelMessage.NOT_A_LONG, numberToken));
        }
    }

    public static Literal getRealLiteral(String numberToken, int pos, boolean isFloat) {
        try {
            if (isFloat) {
                float value = Float.parseFloat(numberToken);
                return new FloatLiteral(numberToken, pos, value);
            }
            double value = Double.parseDouble(numberToken);
            return new RealLiteral(numberToken, pos, value);
        }
        catch (NumberFormatException ex) {
            throw new InternalParseException(new SpelParseException(pos >> 16, (Throwable)ex, SpelMessage.NOT_A_REAL, numberToken));
        }
    }
}

