/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.expression.spel.ast;

import com.att.aft.dme2.internal.springframework.asm.MethodVisitor;
import com.att.aft.dme2.internal.springframework.asm.Type;
import com.att.aft.dme2.internal.springframework.expression.EvaluationException;
import com.att.aft.dme2.internal.springframework.expression.TypedValue;
import com.att.aft.dme2.internal.springframework.expression.spel.CodeFlow;
import com.att.aft.dme2.internal.springframework.expression.spel.ExpressionState;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelEvaluationException;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelMessage;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.Operator;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.SpelNodeImpl;
import com.att.aft.dme2.internal.springframework.expression.spel.ast.TypeReference;
import com.att.aft.dme2.internal.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorInstanceof
extends Operator {
    private Class<?> type;

    public OperatorInstanceof(int pos, SpelNodeImpl ... operands) {
        super("instanceof", pos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl rightOperand = this.getRightOperand();
        TypedValue left = this.getLeftOperand().getValueInternal(state);
        TypedValue right = rightOperand.getValueInternal(state);
        Object leftValue = left.getValue();
        Object rightValue = right.getValue();
        BooleanTypedValue result = null;
        if (rightValue == null || !(rightValue instanceof Class)) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.INSTANCEOF_OPERATOR_NEEDS_CLASS_OPERAND, rightValue == null ? "null" : rightValue.getClass().getName());
        }
        Class rightClass = (Class)rightValue;
        result = leftValue == null ? BooleanTypedValue.FALSE : BooleanTypedValue.forValue(rightClass.isAssignableFrom(leftValue.getClass()));
        this.type = rightClass;
        if (rightOperand instanceof TypeReference) {
            this.exitTypeDescriptor = "Z";
        }
        return result;
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null && this.getLeftOperand().isCompilable();
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        this.getLeftOperand().generateCode(mv, cf);
        CodeFlow.insertBoxIfNecessary(mv, cf.lastDescriptor());
        if (this.type.isPrimitive()) {
            mv.visitInsn(87);
            mv.visitInsn(3);
        } else {
            mv.visitTypeInsn(193, Type.getInternalName(this.type));
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

