/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.expression.spel.support;

import com.att.aft.dme2.internal.springframework.core.convert.ConversionException;
import com.att.aft.dme2.internal.springframework.core.convert.ConversionService;
import com.att.aft.dme2.internal.springframework.core.convert.TypeDescriptor;
import com.att.aft.dme2.internal.springframework.core.convert.support.DefaultConversionService;
import com.att.aft.dme2.internal.springframework.expression.TypeConverter;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelEvaluationException;
import com.att.aft.dme2.internal.springframework.expression.spel.SpelMessage;
import com.att.aft.dme2.internal.springframework.util.Assert;

public class StandardTypeConverter
implements TypeConverter {
    private static volatile ConversionService defaultConversionService;
    private final ConversionService conversionService;

    public StandardTypeConverter() {
        if (defaultConversionService == null) {
            defaultConversionService = new DefaultConversionService();
        }
        this.conversionService = defaultConversionService;
    }

    public StandardTypeConverter(ConversionService conversionService) {
        Assert.notNull(conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    @Override
    public Object convertValue(Object value, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.conversionService.convert(value, sourceType, targetType);
        }
        catch (ConversionException ex) {
            throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, sourceType.toString(), targetType.toString());
        }
    }
}

