/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.format.datetime.standard;

import com.att.aft.dme2.internal.springframework.core.NamedThreadLocal;
import com.att.aft.dme2.internal.springframework.format.datetime.standard.DateTimeContext;
import com.att.aft.dme2.internal.springframework.lang.UsesJava8;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

@UsesJava8
public final class DateTimeContextHolder {
    private static final ThreadLocal<DateTimeContext> dateTimeContextHolder = new NamedThreadLocal<DateTimeContext>("DateTime Context");

    public static void resetDateTimeContext() {
        dateTimeContextHolder.remove();
    }

    public static void setDateTimeContext(DateTimeContext dateTimeContext) {
        if (dateTimeContext == null) {
            DateTimeContextHolder.resetDateTimeContext();
        } else {
            dateTimeContextHolder.set(dateTimeContext);
        }
    }

    public static DateTimeContext getDateTimeContext() {
        return dateTimeContextHolder.get();
    }

    public static DateTimeFormatter getFormatter(DateTimeFormatter formatter, Locale locale) {
        DateTimeFormatter formatterToUse = locale != null ? formatter.withLocale(locale) : formatter;
        DateTimeContext context = DateTimeContextHolder.getDateTimeContext();
        return context != null ? context.getFormatter(formatterToUse) : formatterToUse;
    }
}

