/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.format.datetime.standard;

import com.att.aft.dme2.internal.springframework.context.support.EmbeddedValueResolutionSupport;
import com.att.aft.dme2.internal.springframework.format.AnnotationFormatterFactory;
import com.att.aft.dme2.internal.springframework.format.Parser;
import com.att.aft.dme2.internal.springframework.format.Printer;
import com.att.aft.dme2.internal.springframework.format.annotation.DateTimeFormat;
import com.att.aft.dme2.internal.springframework.format.datetime.standard.DateTimeFormatterFactory;
import com.att.aft.dme2.internal.springframework.format.datetime.standard.TemporalAccessorParser;
import com.att.aft.dme2.internal.springframework.format.datetime.standard.TemporalAccessorPrinter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Jsr310DateTimeFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<DateTimeFormat> {
    private static final Set<Class<?>> FIELD_TYPES;

    @Override
    public final Set<Class<?>> getFieldTypes() {
        return FIELD_TYPES;
    }

    @Override
    public Printer<?> getPrinter(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatter formatter = this.getFormatter(annotation, fieldType);
        return new TemporalAccessorPrinter(formatter);
    }

    @Override
    public Parser<?> getParser(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatter formatter = this.getFormatter(annotation, fieldType);
        return new TemporalAccessorParser(fieldType, formatter);
    }

    protected DateTimeFormatter getFormatter(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatterFactory factory = new DateTimeFormatterFactory();
        factory.setStylePattern(this.resolveEmbeddedValue(annotation.style()));
        factory.setIso(annotation.iso());
        factory.setPattern(this.resolveEmbeddedValue(annotation.pattern()));
        return factory.createDateTimeFormatter();
    }

    static {
        HashSet<Class> fieldTypes = new HashSet<Class>(8);
        fieldTypes.add(LocalDate.class);
        fieldTypes.add(LocalTime.class);
        fieldTypes.add(LocalDateTime.class);
        fieldTypes.add(ZonedDateTime.class);
        fieldTypes.add(OffsetDateTime.class);
        fieldTypes.add(OffsetTime.class);
        FIELD_TYPES = Collections.unmodifiableSet(fieldTypes);
    }
}

