/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.format.number;

import com.att.aft.dme2.internal.springframework.context.support.EmbeddedValueResolutionSupport;
import com.att.aft.dme2.internal.springframework.format.AnnotationFormatterFactory;
import com.att.aft.dme2.internal.springframework.format.Formatter;
import com.att.aft.dme2.internal.springframework.format.Parser;
import com.att.aft.dme2.internal.springframework.format.Printer;
import com.att.aft.dme2.internal.springframework.format.annotation.NumberFormat;
import com.att.aft.dme2.internal.springframework.format.number.CurrencyStyleFormatter;
import com.att.aft.dme2.internal.springframework.format.number.NumberStyleFormatter;
import com.att.aft.dme2.internal.springframework.format.number.PercentStyleFormatter;
import com.att.aft.dme2.internal.springframework.util.NumberUtils;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import java.util.Set;

public class NumberFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<NumberFormat> {
    @Override
    public Set<Class<?>> getFieldTypes() {
        return NumberUtils.STANDARD_NUMBER_TYPES;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation) {
        if (StringUtils.hasLength(annotation.pattern())) {
            return new NumberStyleFormatter(this.resolveEmbeddedValue(annotation.pattern()));
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyStyleFormatter();
        }
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentStyleFormatter();
        }
        return new NumberStyleFormatter();
    }
}

