/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.format.support;

import com.att.aft.dme2.internal.springframework.core.convert.support.DefaultConversionService;
import com.att.aft.dme2.internal.springframework.format.FormatterRegistry;
import com.att.aft.dme2.internal.springframework.format.datetime.DateFormatterRegistrar;
import com.att.aft.dme2.internal.springframework.format.datetime.joda.JodaTimeFormatterRegistrar;
import com.att.aft.dme2.internal.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import com.att.aft.dme2.internal.springframework.format.number.NumberFormatAnnotationFormatterFactory;
import com.att.aft.dme2.internal.springframework.format.number.money.CurrencyUnitFormatter;
import com.att.aft.dme2.internal.springframework.format.number.money.Jsr354NumberFormatAnnotationFormatterFactory;
import com.att.aft.dme2.internal.springframework.format.number.money.MonetaryAmountFormatter;
import com.att.aft.dme2.internal.springframework.format.support.FormattingConversionService;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.StringValueResolver;

public class DefaultFormattingConversionService
extends FormattingConversionService {
    private static final boolean jsr354Present = ClassUtils.isPresent("javax.money.MonetaryAmount", DefaultFormattingConversionService.class.getClassLoader());
    private static final boolean jsr310Present = ClassUtils.isPresent("java.time.LocalDate", DefaultFormattingConversionService.class.getClassLoader());
    private static final boolean jodaTimePresent = ClassUtils.isPresent("org.joda.time.LocalDate", DefaultFormattingConversionService.class.getClassLoader());

    public DefaultFormattingConversionService() {
        this(null, true);
    }

    public DefaultFormattingConversionService(boolean registerDefaultFormatters) {
        this(null, registerDefaultFormatters);
    }

    public DefaultFormattingConversionService(StringValueResolver embeddedValueResolver, boolean registerDefaultFormatters) {
        this.setEmbeddedValueResolver(embeddedValueResolver);
        DefaultConversionService.addDefaultConverters(this);
        if (registerDefaultFormatters) {
            DefaultFormattingConversionService.addDefaultFormatters(this);
        }
    }

    public static void addDefaultFormatters(FormatterRegistry formatterRegistry) {
        formatterRegistry.addFormatterForFieldAnnotation(new NumberFormatAnnotationFormatterFactory());
        if (jsr354Present) {
            formatterRegistry.addFormatter(new CurrencyUnitFormatter());
            formatterRegistry.addFormatter(new MonetaryAmountFormatter());
            formatterRegistry.addFormatterForFieldAnnotation(new Jsr354NumberFormatAnnotationFormatterFactory());
        }
        if (jsr310Present) {
            new DateTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        }
        if (jodaTimePresent) {
            new JodaTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        } else {
            new DateFormatterRegistrar().registerFormatters(formatterRegistry);
        }
    }
}

