/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.format.support;

import com.att.aft.dme2.internal.springframework.context.i18n.LocaleContextHolder;
import com.att.aft.dme2.internal.springframework.format.Formatter;
import com.att.aft.dme2.internal.springframework.format.support.FormattingConversionService;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import java.beans.PropertyEditorSupport;

public class FormatterPropertyEditorAdapter
extends PropertyEditorSupport {
    private final Formatter<Object> formatter;

    public FormatterPropertyEditorAdapter(Formatter<?> formatter) {
        Assert.notNull(formatter, "Formatter must not be null");
        this.formatter = formatter;
    }

    public Class<?> getFieldType() {
        return FormattingConversionService.getFieldType(this.formatter);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            try {
                this.setValue(this.formatter.parse(text, LocaleContextHolder.getLocale()));
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Parse attempt failed for value [" + text + "]", ex);
            }
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        return value != null ? this.formatter.print(value, LocaleContextHolder.getLocale()) : "";
    }
}

