/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.format.support;

import com.att.aft.dme2.internal.springframework.beans.factory.FactoryBean;
import com.att.aft.dme2.internal.springframework.beans.factory.InitializingBean;
import com.att.aft.dme2.internal.springframework.context.EmbeddedValueResolverAware;
import com.att.aft.dme2.internal.springframework.core.convert.support.ConversionServiceFactory;
import com.att.aft.dme2.internal.springframework.format.AnnotationFormatterFactory;
import com.att.aft.dme2.internal.springframework.format.Formatter;
import com.att.aft.dme2.internal.springframework.format.FormatterRegistrar;
import com.att.aft.dme2.internal.springframework.format.support.DefaultFormattingConversionService;
import com.att.aft.dme2.internal.springframework.format.support.FormattingConversionService;
import com.att.aft.dme2.internal.springframework.util.StringValueResolver;
import java.util.Set;

public class FormattingConversionServiceFactoryBean
implements FactoryBean<FormattingConversionService>,
EmbeddedValueResolverAware,
InitializingBean {
    private Set<?> converters;
    private Set<?> formatters;
    private Set<FormatterRegistrar> formatterRegistrars;
    private boolean registerDefaultFormatters = true;
    private StringValueResolver embeddedValueResolver;
    private FormattingConversionService conversionService;

    public void setConverters(Set<?> converters) {
        this.converters = converters;
    }

    public void setFormatters(Set<?> formatters) {
        this.formatters = formatters;
    }

    public void setFormatterRegistrars(Set<FormatterRegistrar> formatterRegistrars) {
        this.formatterRegistrars = formatterRegistrars;
    }

    public void setRegisterDefaultFormatters(boolean registerDefaultFormatters) {
        this.registerDefaultFormatters = registerDefaultFormatters;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }

    @Override
    public void afterPropertiesSet() {
        this.conversionService = new DefaultFormattingConversionService(this.embeddedValueResolver, this.registerDefaultFormatters);
        ConversionServiceFactory.registerConverters(this.converters, this.conversionService);
        this.registerFormatters();
    }

    private void registerFormatters() {
        if (this.formatters != null) {
            for (Object formatter : this.formatters) {
                if (formatter instanceof Formatter) {
                    this.conversionService.addFormatter((Formatter)formatter);
                    continue;
                }
                if (formatter instanceof AnnotationFormatterFactory) {
                    this.conversionService.addFormatterForFieldAnnotation((AnnotationFormatterFactory)formatter);
                    continue;
                }
                throw new IllegalArgumentException("Custom formatters must be implementations of Formatter or AnnotationFormatterFactory");
            }
        }
        if (this.formatterRegistrars != null) {
            for (FormatterRegistrar registrar : this.formatterRegistrars) {
                registrar.registerFormatters(this.conversionService);
            }
        }
    }

    @Override
    public FormattingConversionService getObject() {
        return this.conversionService;
    }

    @Override
    public Class<? extends FormattingConversionService> getObjectType() {
        return FormattingConversionService.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

