/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.instrument.classloading;

import com.att.aft.dme2.internal.springframework.instrument.classloading.LoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.SimpleInstrumentableClassLoader;
import com.att.aft.dme2.internal.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class SimpleLoadTimeWeaver
implements LoadTimeWeaver {
    private final SimpleInstrumentableClassLoader classLoader;

    public SimpleLoadTimeWeaver() {
        this.classLoader = new SimpleInstrumentableClassLoader(ClassUtils.getDefaultClassLoader());
    }

    public SimpleLoadTimeWeaver(SimpleInstrumentableClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

