/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.instrument.classloading.jboss;

import com.att.aft.dme2.internal.springframework.instrument.classloading.LoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import com.att.aft.dme2.internal.springframework.instrument.classloading.jboss.JBossClassLoaderAdapter;
import com.att.aft.dme2.internal.springframework.instrument.classloading.jboss.JBossMCAdapter;
import com.att.aft.dme2.internal.springframework.instrument.classloading.jboss.JBossModulesAdapter;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class JBossLoadTimeWeaver
implements LoadTimeWeaver {
    private final JBossClassLoaderAdapter adapter;

    public JBossLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public JBossLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.adapter = classLoader.getClass().getName().startsWith("org.jboss.modules") ? new JBossModulesAdapter(classLoader) : new JBossMCAdapter(classLoader);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.adapter.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.adapter.getInstrumentableClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

