/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.instrument.classloading.websphere;

import com.att.aft.dme2.internal.springframework.core.OverridingClassLoader;
import com.att.aft.dme2.internal.springframework.instrument.classloading.LoadTimeWeaver;
import com.att.aft.dme2.internal.springframework.instrument.classloading.websphere.WebSphereClassLoaderAdapter;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class WebSphereLoadTimeWeaver
implements LoadTimeWeaver {
    private final WebSphereClassLoaderAdapter classLoader;

    public WebSphereLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public WebSphereLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = new WebSphereClassLoaderAdapter(classLoader);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader.getClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new OverridingClassLoader(this.classLoader.getClassLoader(), this.classLoader.getThrowawayClassLoader());
    }
}

