/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.objenesis.strategy;

import com.att.aft.dme2.internal.springframework.objenesis.ObjenesisException;
import com.att.aft.dme2.internal.springframework.objenesis.instantiator.ObjectInstantiator;
import com.att.aft.dme2.internal.springframework.objenesis.instantiator.android.AndroidSerializationInstantiator;
import com.att.aft.dme2.internal.springframework.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import com.att.aft.dme2.internal.springframework.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import com.att.aft.dme2.internal.springframework.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import com.att.aft.dme2.internal.springframework.objenesis.instantiator.perc.PercSerializationInstantiator;
import com.att.aft.dme2.internal.springframework.objenesis.strategy.BaseInstantiatorStrategy;
import com.att.aft.dme2.internal.springframework.objenesis.strategy.PlatformDescription;
import java.io.NotSerializableException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine()) {
                return new ObjectInputStreamInstantiator<T>(type);
            }
            return new ObjectStreamClassInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type);
            }
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new ObjectStreamClassInstantiator<T>(type);
    }
}

