/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.scheduling.annotation;

import com.att.aft.dme2.internal.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import com.att.aft.dme2.internal.springframework.beans.factory.annotation.Autowired;
import com.att.aft.dme2.internal.springframework.context.annotation.Configuration;
import com.att.aft.dme2.internal.springframework.context.annotation.ImportAware;
import com.att.aft.dme2.internal.springframework.core.annotation.AnnotationAttributes;
import com.att.aft.dme2.internal.springframework.core.type.AnnotationMetadata;
import com.att.aft.dme2.internal.springframework.scheduling.annotation.AsyncConfigurer;
import com.att.aft.dme2.internal.springframework.scheduling.annotation.EnableAsync;
import com.att.aft.dme2.internal.springframework.util.CollectionUtils;
import java.util.Collection;
import java.util.concurrent.Executor;

@Configuration
public abstract class AbstractAsyncConfiguration
implements ImportAware {
    protected AnnotationAttributes enableAsync;
    protected Executor executor;
    protected AsyncUncaughtExceptionHandler exceptionHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableAsync = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableAsync.class.getName(), false));
        if (this.enableAsync == null) {
            throw new IllegalArgumentException("@EnableAsync is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<AsyncConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one AsyncConfigurer may exist");
        }
        AsyncConfigurer configurer = configurers.iterator().next();
        this.executor = configurer.getAsyncExecutor();
        this.exceptionHandler = configurer.getAsyncUncaughtExceptionHandler();
    }
}

