/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.scheduling.concurrent;

import com.att.aft.dme2.internal.springframework.core.task.AsyncListenableTaskExecutor;
import com.att.aft.dme2.internal.springframework.core.task.TaskDecorator;
import com.att.aft.dme2.internal.springframework.core.task.support.TaskExecutorAdapter;
import com.att.aft.dme2.internal.springframework.scheduling.SchedulingAwareRunnable;
import com.att.aft.dme2.internal.springframework.scheduling.SchedulingTaskExecutor;
import com.att.aft.dme2.internal.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import com.att.aft.dme2.internal.springframework.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.enterprise.concurrent.ManagedExecutors;

public class ConcurrentTaskExecutor
implements AsyncListenableTaskExecutor,
SchedulingTaskExecutor {
    private static Class<?> managedExecutorServiceClass;
    private Executor concurrentExecutor;
    private TaskExecutorAdapter adaptedExecutor;

    public ConcurrentTaskExecutor() {
        this.setConcurrentExecutor(null);
    }

    public ConcurrentTaskExecutor(Executor concurrentExecutor) {
        this.setConcurrentExecutor(concurrentExecutor);
    }

    public final void setConcurrentExecutor(Executor concurrentExecutor) {
        if (concurrentExecutor != null) {
            this.concurrentExecutor = concurrentExecutor;
            this.adaptedExecutor = managedExecutorServiceClass != null && managedExecutorServiceClass.isInstance(concurrentExecutor) ? new ManagedTaskExecutorAdapter(concurrentExecutor) : new TaskExecutorAdapter(concurrentExecutor);
        } else {
            this.concurrentExecutor = Executors.newSingleThreadExecutor();
            this.adaptedExecutor = new TaskExecutorAdapter(this.concurrentExecutor);
        }
    }

    public final Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.adaptedExecutor.setTaskDecorator(taskDecorator);
    }

    @Override
    public void execute(Runnable task) {
        this.adaptedExecutor.execute(task);
    }

    @Override
    public void execute(Runnable task, long startTimeout) {
        this.adaptedExecutor.execute(task, startTimeout);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.adaptedExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.adaptedExecutor.submit(task);
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.adaptedExecutor.submitListenable(task);
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.adaptedExecutor.submitListenable(task);
    }

    @Override
    public boolean prefersShortLivedTasks() {
        return true;
    }

    static {
        try {
            managedExecutorServiceClass = ClassUtils.forName("javax.enterprise.concurrent.ManagedExecutorService", ConcurrentTaskScheduler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            managedExecutorServiceClass = null;
        }
    }

    protected static class ManagedTaskBuilder {
        protected ManagedTaskBuilder() {
        }

        public static Runnable buildManagedTask(Runnable task, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            if (task instanceof SchedulingAwareRunnable) {
                properties.put("javax.enterprise.concurrent.LONGRUNNING_HINT", Boolean.toString(((SchedulingAwareRunnable)task).isLongLived()));
            }
            properties.put("javax.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask((Runnable)task, properties, null);
        }

        public static <T> Callable<T> buildManagedTask(Callable<T> task, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("javax.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask(task, properties, null);
        }
    }

    private static class ManagedTaskExecutorAdapter
    extends TaskExecutorAdapter {
        public ManagedTaskExecutorAdapter(Executor concurrentExecutor) {
            super(concurrentExecutor);
        }

        @Override
        public void execute(Runnable task) {
            super.execute(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public Future<?> submit(Runnable task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public ListenableFuture<?> submitListenable(Runnable task) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }
    }
}

