/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.scheduling.config;

import com.att.aft.dme2.internal.springframework.beans.factory.BeanNameAware;
import com.att.aft.dme2.internal.springframework.beans.factory.DisposableBean;
import com.att.aft.dme2.internal.springframework.beans.factory.FactoryBean;
import com.att.aft.dme2.internal.springframework.beans.factory.InitializingBean;
import com.att.aft.dme2.internal.springframework.core.task.TaskExecutor;
import com.att.aft.dme2.internal.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import com.att.aft.dme2.internal.springframework.util.StringUtils;
import java.util.concurrent.RejectedExecutionHandler;

public class TaskExecutorFactoryBean
implements FactoryBean<TaskExecutor>,
BeanNameAware,
InitializingBean,
DisposableBean {
    private String poolSize;
    private Integer queueCapacity;
    private RejectedExecutionHandler rejectedExecutionHandler;
    private Integer keepAliveSeconds;
    private String beanName;
    private ThreadPoolTaskExecutor target;

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void afterPropertiesSet() {
        this.target = new ThreadPoolTaskExecutor();
        this.determinePoolSizeRange();
        if (this.queueCapacity != null) {
            this.target.setQueueCapacity(this.queueCapacity);
        }
        if (this.keepAliveSeconds != null) {
            this.target.setKeepAliveSeconds(this.keepAliveSeconds);
        }
        if (this.rejectedExecutionHandler != null) {
            this.target.setRejectedExecutionHandler(this.rejectedExecutionHandler);
        }
        if (this.beanName != null) {
            this.target.setThreadNamePrefix(this.beanName + "-");
        }
        this.target.afterPropertiesSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determinePoolSizeRange() {
        if (!StringUtils.hasText(this.poolSize)) return;
        try {
            int maxPoolSize;
            int corePoolSize;
            int separatorIndex = this.poolSize.indexOf(45);
            if (separatorIndex != -1) {
                corePoolSize = Integer.valueOf(this.poolSize.substring(0, separatorIndex));
                if (corePoolSize > (maxPoolSize = Integer.valueOf(this.poolSize.substring(separatorIndex + 1, this.poolSize.length())).intValue())) {
                    throw new IllegalArgumentException("Lower bound of pool-size range must not exceed the upper bound");
                }
                if (this.queueCapacity == null) {
                    if (corePoolSize != 0) throw new IllegalArgumentException("A non-zero lower bound for the size range requires a queue-capacity value");
                    this.target.setAllowCoreThreadTimeOut(true);
                    corePoolSize = maxPoolSize;
                }
            } else {
                Integer value = Integer.valueOf(this.poolSize);
                corePoolSize = value;
                maxPoolSize = value;
            }
            this.target.setCorePoolSize(corePoolSize);
            this.target.setMaxPoolSize(maxPoolSize);
            return;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid pool-size value [" + this.poolSize + "]: only single maximum integer (e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported", ex);
        }
    }

    @Override
    public TaskExecutor getObject() {
        return this.target;
    }

    @Override
    public Class<? extends TaskExecutor> getObjectType() {
        return this.target != null ? this.target.getClass() : ThreadPoolTaskExecutor.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() {
        this.target.destroy();
    }
}

