/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.scripting.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanClassLoaderAware;
import com.att.aft.dme2.internal.springframework.scripting.ScriptCompilationException;
import com.att.aft.dme2.internal.springframework.scripting.ScriptEvaluator;
import com.att.aft.dme2.internal.springframework.scripting.ScriptSource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

public class BshScriptEvaluator
implements ScriptEvaluator,
BeanClassLoaderAware {
    private ClassLoader classLoader;

    public BshScriptEvaluator() {
    }

    public BshScriptEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object evaluate(ScriptSource script) {
        return this.evaluate(script, null);
    }

    @Override
    public Object evaluate(ScriptSource script, Map<String, Object> arguments) {
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.setClassLoader(this.classLoader);
            if (arguments != null) {
                for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                    interpreter.set(entry.getKey(), entry.getValue());
                }
            }
            return interpreter.eval((Reader)new StringReader(script.getScriptAsString()));
        }
        catch (IOException ex) {
            throw new ScriptCompilationException(script, "Cannot access BeanShell script", ex);
        }
        catch (EvalError ex) {
            throw new ScriptCompilationException(script, (Throwable)ex);
        }
    }
}

