/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.scripting.bsh;

import bsh.EvalError;
import com.att.aft.dme2.internal.springframework.beans.factory.BeanClassLoaderAware;
import com.att.aft.dme2.internal.springframework.scripting.ScriptCompilationException;
import com.att.aft.dme2.internal.springframework.scripting.ScriptFactory;
import com.att.aft.dme2.internal.springframework.scripting.ScriptSource;
import com.att.aft.dme2.internal.springframework.scripting.bsh.BshScriptUtils;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.io.IOException;

public class BshScriptFactory
implements ScriptFactory,
BeanClassLoaderAware {
    private final String scriptSourceLocator;
    private final Class<?>[] scriptInterfaces;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Class<?> scriptClass;
    private final Object scriptClassMonitor = new Object();
    private boolean wasModifiedForTypeCheck = false;

    public BshScriptFactory(String scriptSourceLocator) {
        Assert.hasText(scriptSourceLocator, "'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = null;
    }

    public BshScriptFactory(String scriptSourceLocator, Class<?> ... scriptInterfaces) {
        Assert.hasText(scriptSourceLocator, "'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    @Override
    public Class<?>[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    @Override
    public boolean requiresConfigInterface() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getScriptedObject(ScriptSource scriptSource, Class<?> ... actualInterfaces) throws IOException, ScriptCompilationException {
        Class<?> clazz;
        try {
            Object object = this.scriptClassMonitor;
            synchronized (object) {
                boolean requiresScriptEvaluation = this.wasModifiedForTypeCheck && this.scriptClass == null;
                this.wasModifiedForTypeCheck = false;
                if (scriptSource.isModified() || requiresScriptEvaluation) {
                    Object result = BshScriptUtils.evaluateBshScript(scriptSource.getScriptAsString(), actualInterfaces, this.beanClassLoader);
                    if (result instanceof Class) {
                        this.scriptClass = (Class)result;
                    } else {
                        return result;
                    }
                }
                clazz = this.scriptClass;
            }
        }
        catch (EvalError ex) {
            this.scriptClass = null;
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Throwable ex) {
                throw new ScriptCompilationException(scriptSource, "Could not instantiate script class: " + clazz.getName(), ex);
            }
        }
        try {
            return BshScriptUtils.createBshObject(scriptSource.getScriptAsString(), actualInterfaces, this.beanClassLoader);
        }
        catch (EvalError ex) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
    }

    @Override
    public Class<?> getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            try {
                if (scriptSource.isModified()) {
                    this.wasModifiedForTypeCheck = true;
                    this.scriptClass = BshScriptUtils.determineBshObjectType(scriptSource.getScriptAsString(), this.beanClassLoader);
                }
                return this.scriptClass;
            }
            catch (EvalError ex) {
                this.scriptClass = null;
                throw new ScriptCompilationException(scriptSource, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            return scriptSource.isModified() || this.wasModifiedForTypeCheck;
        }
    }

    public String toString() {
        return "BshScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

