/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.ui.context.support;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import com.att.aft.dme2.internal.apache.commons.logging.LogFactory;
import com.att.aft.dme2.internal.springframework.context.ApplicationContext;
import com.att.aft.dme2.internal.springframework.ui.context.HierarchicalThemeSource;
import com.att.aft.dme2.internal.springframework.ui.context.ThemeSource;
import com.att.aft.dme2.internal.springframework.ui.context.support.DelegatingThemeSource;
import com.att.aft.dme2.internal.springframework.ui.context.support.ResourceBundleThemeSource;

public abstract class UiApplicationContextUtils {
    public static final String THEME_SOURCE_BEAN_NAME = "themeSource";
    private static final Log logger = LogFactory.getLog(UiApplicationContextUtils.class);

    public static ThemeSource initThemeSource(ApplicationContext context) {
        if (context.containsLocalBean(THEME_SOURCE_BEAN_NAME)) {
            HierarchicalThemeSource hts;
            ThemeSource themeSource = context.getBean(THEME_SOURCE_BEAN_NAME, ThemeSource.class);
            if (context.getParent() instanceof ThemeSource && themeSource instanceof HierarchicalThemeSource && (hts = (HierarchicalThemeSource)themeSource).getParentThemeSource() == null) {
                hts.setParentThemeSource((ThemeSource)((Object)context.getParent()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Using ThemeSource [" + themeSource + "]");
            }
            return themeSource;
        }
        HierarchicalThemeSource themeSource = null;
        if (context.getParent() instanceof ThemeSource) {
            themeSource = new DelegatingThemeSource();
            themeSource.setParentThemeSource((ThemeSource)((Object)context.getParent()));
        } else {
            themeSource = new ResourceBundleThemeSource();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Unable to locate ThemeSource with name 'themeSource': using default [" + themeSource + "]");
        }
        return themeSource;
    }
}

