/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.util;

import com.att.aft.dme2.internal.apache.commons.codec.binary.Base64;
import com.att.aft.dme2.internal.springframework.lang.UsesJava8;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.util.ClassUtils;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

public abstract class Base64Utils {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Base64Delegate delegate;

    private static void assertDelegateAvailable() {
        Assert.state(delegate != null, "Neither Java 8 nor Apache Commons Codec found - Base64 encoding between byte arrays not supported");
    }

    public static byte[] encode(byte[] src) {
        Base64Utils.assertDelegateAvailable();
        return delegate.encode(src);
    }

    public static byte[] decode(byte[] src) {
        Base64Utils.assertDelegateAvailable();
        return delegate.decode(src);
    }

    public static byte[] encodeUrlSafe(byte[] src) {
        Base64Utils.assertDelegateAvailable();
        return delegate.encodeUrlSafe(src);
    }

    public static byte[] decodeUrlSafe(byte[] src) {
        Base64Utils.assertDelegateAvailable();
        return delegate.decodeUrlSafe(src);
    }

    public static String encodeToString(byte[] src) {
        if (src == null) {
            return null;
        }
        if (src.length == 0) {
            return "";
        }
        if (delegate != null) {
            return new String(delegate.encode(src), DEFAULT_CHARSET);
        }
        return DatatypeConverter.printBase64Binary((byte[])src);
    }

    public static byte[] decodeFromString(String src) {
        if (src == null) {
            return null;
        }
        if (src.length() == 0) {
            return new byte[0];
        }
        if (delegate != null) {
            return delegate.decode(src.getBytes(DEFAULT_CHARSET));
        }
        return DatatypeConverter.parseBase64Binary((String)src);
    }

    public static String encodeToUrlSafeString(byte[] src) {
        Base64Utils.assertDelegateAvailable();
        return new String(delegate.encodeUrlSafe(src), DEFAULT_CHARSET);
    }

    public static byte[] decodeFromUrlSafeString(String src) {
        Base64Utils.assertDelegateAvailable();
        return delegate.decodeUrlSafe(src.getBytes(DEFAULT_CHARSET));
    }

    static {
        Base64Delegate delegateToUse = null;
        if (ClassUtils.isPresent("java.util.Base64", Base64Utils.class.getClassLoader())) {
            delegateToUse = new JdkBase64Delegate();
        } else if (ClassUtils.isPresent("com.att.aft.dme2.internal.apache.commons.codec.binary.Base64", Base64Utils.class.getClassLoader())) {
            delegateToUse = new CommonsCodecBase64Delegate();
        }
        delegate = delegateToUse;
    }

    static class CommonsCodecBase64Delegate
    implements Base64Delegate {
        private final Base64 base64 = new Base64();
        private final Base64 base64UrlSafe = new Base64(0, null, true);

        CommonsCodecBase64Delegate() {
        }

        @Override
        public byte[] encode(byte[] src) {
            return this.base64.encode(src);
        }

        @Override
        public byte[] decode(byte[] src) {
            return this.base64.decode(src);
        }

        @Override
        public byte[] encodeUrlSafe(byte[] src) {
            return this.base64UrlSafe.encode(src);
        }

        @Override
        public byte[] decodeUrlSafe(byte[] src) {
            return this.base64UrlSafe.decode(src);
        }
    }

    @UsesJava8
    static class JdkBase64Delegate
    implements Base64Delegate {
        JdkBase64Delegate() {
        }

        @Override
        public byte[] encode(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return java.util.Base64.getEncoder().encode(src);
        }

        @Override
        public byte[] decode(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return java.util.Base64.getDecoder().decode(src);
        }

        @Override
        public byte[] encodeUrlSafe(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return java.util.Base64.getUrlEncoder().encode(src);
        }

        @Override
        public byte[] decodeUrlSafe(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return java.util.Base64.getUrlDecoder().decode(src);
        }
    }

    static interface Base64Delegate {
        public byte[] encode(byte[] var1);

        public byte[] decode(byte[] var1);

        public byte[] encodeUrlSafe(byte[] var1);

        public byte[] decodeUrlSafe(byte[] var1);
    }
}

