/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.util.concurrent;

import com.att.aft.dme2.internal.springframework.util.concurrent.FailureCallback;
import com.att.aft.dme2.internal.springframework.util.concurrent.FutureAdapter;
import com.att.aft.dme2.internal.springframework.util.concurrent.ListenableFuture;
import com.att.aft.dme2.internal.springframework.util.concurrent.ListenableFutureCallback;
import com.att.aft.dme2.internal.springframework.util.concurrent.SuccessCallback;
import java.util.concurrent.ExecutionException;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.addCallback(callback, callback);
    }

    @Override
    public void addCallback(final SuccessCallback<? super T> successCallback, final FailureCallback failureCallback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(S result) {
                Object adapted;
                try {
                    adapted = ListenableFutureAdapter.this.adaptInternal(result);
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    this.onFailure(cause != null ? cause : ex);
                    return;
                }
                catch (Throwable ex) {
                    this.onFailure(ex);
                    return;
                }
                successCallback.onSuccess(adapted);
            }

            @Override
            public void onFailure(Throwable ex) {
                failureCallback.onFailure(ex);
            }
        });
    }
}

