/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.validation;

import com.att.aft.dme2.internal.springframework.beans.BeanWrapper;
import com.att.aft.dme2.internal.springframework.beans.ConfigurablePropertyAccessor;
import com.att.aft.dme2.internal.springframework.beans.PropertyAccessorFactory;
import com.att.aft.dme2.internal.springframework.util.Assert;
import com.att.aft.dme2.internal.springframework.validation.AbstractPropertyBindingResult;
import java.io.Serializable;

public class BeanPropertyBindingResult
extends AbstractPropertyBindingResult
implements Serializable {
    private final Object target;
    private final boolean autoGrowNestedPaths;
    private final int autoGrowCollectionLimit;
    private transient BeanWrapper beanWrapper;

    public BeanPropertyBindingResult(Object target, String objectName) {
        this(target, objectName, true, Integer.MAX_VALUE);
    }

    public BeanPropertyBindingResult(Object target, String objectName, boolean autoGrowNestedPaths, int autoGrowCollectionLimit) {
        super(objectName);
        this.target = target;
        this.autoGrowNestedPaths = autoGrowNestedPaths;
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    @Override
    public final Object getTarget() {
        return this.target;
    }

    @Override
    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.beanWrapper == null) {
            this.beanWrapper = this.createBeanWrapper();
            this.beanWrapper.setExtractOldValueForEditor(true);
            this.beanWrapper.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
            this.beanWrapper.setAutoGrowCollectionLimit(this.autoGrowCollectionLimit);
        }
        return this.beanWrapper;
    }

    protected BeanWrapper createBeanWrapper() {
        Assert.state(this.target != null, "Cannot access properties on null bean instance '" + this.getObjectName() + "'!");
        return PropertyAccessorFactory.forBeanPropertyAccess(this.target);
    }
}

