/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.springframework.validation.beanvalidation;

import com.att.aft.dme2.internal.springframework.beans.factory.InitializingBean;
import com.att.aft.dme2.internal.springframework.validation.beanvalidation.LocaleContextMessageInterpolator;
import com.att.aft.dme2.internal.springframework.validation.beanvalidation.SpringValidatorAdapter;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;

public class CustomValidatorBean
extends SpringValidatorAdapter
implements Validator,
InitializingBean {
    private ValidatorFactory validatorFactory;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.validatorFactory == null) {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
        ValidatorContext validatorContext = this.validatorFactory.usingContext();
        MessageInterpolator targetInterpolator = this.messageInterpolator;
        if (targetInterpolator == null) {
            targetInterpolator = this.validatorFactory.getMessageInterpolator();
        }
        validatorContext.messageInterpolator((MessageInterpolator)new LocaleContextMessageInterpolator(targetInterpolator));
        if (this.traversableResolver != null) {
            validatorContext.traversableResolver(this.traversableResolver);
        }
        this.setTargetValidator(validatorContext.getValidator());
    }
}

