/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.iterator.domain.IteratorCreatingAttributes;
import com.att.aft.dme2.iterator.helper.StaleProcessor;
import com.att.aft.dme2.iterator.metrics.DefaultEndpointIteratorMetricsCollection;
import com.att.aft.dme2.iterator.service.DME2BaseEndpointIterator;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;

public class DME2EndpointIterator
extends DefaultEndpointIteratorMetricsCollection
implements DME2BaseEndpointIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DME2EndpointIterator.class.getName());
    private static final Logger FAILBACK_LOGGER = LoggerFactory.getLogger("com.att.aft.dme2.events.failbackLogger");
    private final boolean failbackLoggingEnabled = true;
    private String routeOffersTried;
    private DME2Manager manager;
    private String queryParamMinActiveEndPoint;
    private final List<DME2EndpointReference> originalOrderedEndpointHolders;
    private List<DME2EndpointReference> orderedEndpointHolders;
    private final List<DME2EndpointReference> staleEndpointReferences = new ArrayList<DME2EndpointReference>();
    private final List<DME2EndpointReference> removedEndpointReferences = new ArrayList<DME2EndpointReference>();
    private DME2Endpoint currentEndpoint;
    private DME2RouteOffer currentRouteOffer;
    private DME2EndpointReference currentEndpointHolder;
    private int currentSequence;
    private int currentEndpointListIndexPosition;
    private int staleEndpointListIndexPosition;
    private int endpointListSize;
    private double currentDistanceBand;
    private boolean elementReturned;
    private int minActiveEndPoints;

    public DME2EndpointIterator(DME2Manager manager, List<DME2EndpointReference> endpointReferenceList, String queryParamMinActiveEndPoint) throws DME2Exception {
        super(manager, endpointReferenceList, queryParamMinActiveEndPoint);
        LOGGER.debug(null, "DefaultEndpointIterator", "start");
        this.manager = manager;
        this.originalOrderedEndpointHolders = Collections.unmodifiableList(endpointReferenceList);
        this.orderedEndpointHolders = endpointReferenceList;
        LOGGER.debug(null, "DefaultEndpointIterator", "queryParamMinActiveEndPoint=" + queryParamMinActiveEndPoint);
        this.minActiveEndPoints = queryParamMinActiveEndPoint == null ? manager.getIntProp("DME2_MIN_ACTIVE_END_POINTS", 0) : Integer.parseInt(queryParamMinActiveEndPoint);
        this.orderedEndpointHolders = this.minActiveEndPoints == 0 ? endpointReferenceList : this.getMinActiveEndpointsList(this.orderedEndpointHolders, this.minActiveEndPoints);
        this.initialize();
        LOGGER.debug(null, "DefaultEndpointIterator", "end");
    }

    public DME2EndpointIterator(IteratorCreatingAttributes iteratorCreatingAttributes) throws DME2Exception {
        super(iteratorCreatingAttributes);
        LOGGER.debug(null, "DefaultEndpointIterator", "start");
        this.manager = iteratorCreatingAttributes.getManager();
        if (this.manager == null) {
            this.manager = DME2Manager.getDefaultInstance();
        }
        this.originalOrderedEndpointHolders = Collections.unmodifiableList(iteratorCreatingAttributes.getEndpointHolders());
        this.orderedEndpointHolders = iteratorCreatingAttributes.getEndpointHolders();
        LOGGER.debug(null, "DefaultEndpointIterator", "queryParamMinActiveEndPoint=" + iteratorCreatingAttributes.getQueryParamMinActiveEndPoint());
        this.minActiveEndPoints = iteratorCreatingAttributes.getQueryParamMinActiveEndPoint() == null ? this.manager.getIntProp("DME2_MIN_ACTIVE_END_POINTS", 0) : Integer.parseInt(iteratorCreatingAttributes.getQueryParamMinActiveEndPoint());
        this.orderedEndpointHolders = this.minActiveEndPoints == 0 ? iteratorCreatingAttributes.getEndpointHolders() : this.getMinActiveEndpointsList(this.orderedEndpointHolders, this.minActiveEndPoints);
        this.initialize();
        LOGGER.debug(null, "DefaultEndpointIterator", "end");
    }

    private void initialize() {
        LOGGER.debug(null, "initialize", "start");
        this.endpointListSize = this.originalOrderedEndpointHolders.size();
        LOGGER.debug((URI)null, "initialize", "Size of EndpointReference list: {}", (Object)this.endpointListSize);
        this.currentEndpointListIndexPosition = -1;
        LOGGER.debug((URI)null, "initialize", "Starting EndpointReference list index position: {}", (Object)this.currentEndpointListIndexPosition);
        this.staleEndpointListIndexPosition = -1;
        LOGGER.debug(null, "initialize", "end");
    }

    private List<DME2EndpointReference> getMinActiveEndpointsList(List<DME2EndpointReference> copyOforiginalOrderedEndpointHolder, int minActiveEndpoints) {
        LOGGER.debug(null, "getMinActiveEndpointsList", "start");
        int mAE = 0;
        ArrayList<DME2EndpointReference> orderedEndpointHolders = new ArrayList<DME2EndpointReference>();
        DME2EndpointReference lastReferenceBeforeMinActiveEndpointCount = null;
        Collections.sort(copyOforiginalOrderedEndpointHolder, new Comparator<DME2EndpointReference>(){

            @Override
            public int compare(DME2EndpointReference o1, DME2EndpointReference o2) {
                return o1.getSequence().compareTo(o2.getSequence());
            }
        });
        for (DME2EndpointReference orderedEndpointHolder : copyOforiginalOrderedEndpointHolder) {
            if (mAE >= minActiveEndpoints) {
                List<DME2EndpointReference> copyOforiginalEndpointReferenceListSubList = copyOforiginalOrderedEndpointHolder.subList(mAE, copyOforiginalOrderedEndpointHolder.size());
                for (DME2EndpointReference tmpOrderedEndpointHolder : copyOforiginalEndpointReferenceListSubList) {
                    if (lastReferenceBeforeMinActiveEndpointCount.getSequence() != tmpOrderedEndpointHolder.getSequence() || StaleProcessor.isStale(this.manager, tmpOrderedEndpointHolder.getEndpoint())) continue;
                    orderedEndpointHolders.add(tmpOrderedEndpointHolder);
                }
                break;
            }
            if (StaleProcessor.isStale(this.manager, orderedEndpointHolder.getEndpoint())) continue;
            orderedEndpointHolders.add(orderedEndpointHolder);
            lastReferenceBeforeMinActiveEndpointCount = orderedEndpointHolder;
            ++mAE;
        }
        for (DME2EndpointReference tmpOrderedEndpointHolder : orderedEndpointHolders) {
            tmpOrderedEndpointHolder.getRouteOffer().getRouteOffer().setSequence(lastReferenceBeforeMinActiveEndpointCount.getSequence());
            tmpOrderedEndpointHolder.setSequence(lastReferenceBeforeMinActiveEndpointCount.getSequence());
        }
        LOGGER.debug(null, "getMinActiveEndpointsList", "end");
        return orderedEndpointHolders;
    }

    @Override
    public boolean hasNext() {
        return this.currentEndpointListIndexPosition < this.orderedEndpointHolders.size() - 1 || this.staleEndpointListIndexPosition < this.staleEndpointReferences.size() - 1;
    }

    @Override
    public DME2EndpointReference next() {
        LOGGER.debug(null, "next", LogMessage.METHOD_ENTER);
        DME2EndpointReference orderedEndpointHolder = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more Endpoint References are available in the Iterator.");
        }
        while (this.hasNext()) {
            if (!this.isPrimaryEndpointReferenceListExhausted()) {
                ++this.currentEndpointListIndexPosition;
                LOGGER.debug((URI)null, "next", LogMessage.DEBUG_MESSAGE, (Object)"Current primary EndpointHolders list index position: {}", (Object)this.currentEndpointListIndexPosition);
                orderedEndpointHolder = this.orderedEndpointHolders.get(this.currentEndpointListIndexPosition);
                if (orderedEndpointHolder.getEndpoint() != null && StaleProcessor.isStale(this.manager, orderedEndpointHolder.getEndpoint())) {
                    String msg = String.format("DME2Endpoint %s is stale. Skipping and continuing through the iteration to find the next available Endpoint.", orderedEndpointHolder.getEndpoint());
                    LOGGER.debug((URI)null, "next", LogMessage.DEBUG_MESSAGE, (Object)msg);
                    this.staleEndpointReferences.add(orderedEndpointHolder);
                    this.orderedEndpointHolders.remove(this.currentEndpointListIndexPosition);
                    --this.currentEndpointListIndexPosition;
                    continue;
                }
            } else if (!this.isStaleEndpointReferenceListExhausted()) {
                ++this.staleEndpointListIndexPosition;
                LOGGER.debug((URI)null, "next", LogMessage.DEBUG_MESSAGE, (Object)"Current stale Endpoint Holders index position: {}", (Object)this.staleEndpointListIndexPosition);
                orderedEndpointHolder = this.staleEndpointReferences.get(this.staleEndpointListIndexPosition);
                FAILBACK_LOGGER.debug((URI)null, "next", "FailBack: Code=Client.Send; Failing back endpoint(s): {}", (Object)orderedEndpointHolder.getEndpoint().toURLString());
            }
            this.currentEndpointHolder = orderedEndpointHolder;
            this.currentEndpoint = this.currentEndpointHolder.getEndpoint();
            this.currentSequence = this.currentEndpointHolder.getSequence();
            this.currentRouteOffer = this.currentEndpointHolder.getRouteOffer();
            this.currentDistanceBand = this.currentEndpointHolder.getDistanceBand();
            LOGGER.debug((URI)null, "next", LogMessage.DEBUG_MESSAGE, (Object)"printEndpointReferenceDetails: {}", (Object)this.printEndpointReferenceDetails());
            break;
        }
        this.elementReturned = true;
        LOGGER.debug(null, "next", LogMessage.METHOD_EXIT);
        return orderedEndpointHolder;
    }

    @Override
    public void remove() {
        LOGGER.debug(null, "remove", LogMessage.METHOD_ENTER);
        if (!this.elementReturned) {
            throw new IllegalStateException("Error occured - removed() cannot be called before called next(). Additionally, the remove() method can be called only once per call to next().");
        }
        LOGGER.debug((URI)null, "remove", "Removing EndpointReference from the Iterator: {}", (Object)this.printEndpointReferenceDetails());
        if (this.orderedEndpointHolders.size() != 0) {
            this.removedEndpointReferences.add(this.currentEndpointHolder);
            this.orderedEndpointHolders.remove(this.currentEndpointListIndexPosition);
            --this.currentEndpointListIndexPosition;
            LOGGER.debug((URI)null, "remove", "Current primary EndpointReference list index position after removing EndpointReference from the Iterator: {}", (Object)this.currentEndpointListIndexPosition);
        } else if (this.staleEndpointReferences.size() != 0) {
            this.removedEndpointReferences.add(this.currentEndpointHolder);
            this.staleEndpointReferences.remove(this.staleEndpointListIndexPosition);
            --this.staleEndpointListIndexPosition;
            LOGGER.debug((URI)null, "remove", "Current stale EndpointReference list index position after removing EndpointReference from the Iterator: {}", (Object)this.staleEndpointListIndexPosition);
            FAILBACK_LOGGER.debug((URI)null, "remove", "Code=Client.Send; Failing back endpoint(s) [{}]", (Object)this.currentEndpointHolder.getEndpoint().toURLString());
        }
        this.elementReturned = false;
        LOGGER.debug(null, "remove", LogMessage.METHOD_EXIT);
    }

    @Override
    public void setRouteOffersTried(String routeOffersTried) {
        this.routeOffersTried = routeOffersTried;
    }

    @Override
    public String getRouteOffersTried() {
        return this.routeOffersTried;
    }

    private boolean isPrimaryEndpointReferenceListExhausted() {
        return this.currentEndpointListIndexPosition == this.orderedEndpointHolders.size() - 1;
    }

    private boolean isStaleEndpointReferenceListExhausted() {
        return this.staleEndpointListIndexPosition == this.staleEndpointReferences.size() - 1;
    }

    private String printEndpointReferenceDetails() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("currentSequence=" + this.currentSequence + "; ");
        sb.append("currentDistanceBand=" + this.currentDistanceBand + "; ");
        sb.append("currentEndpoint=" + (this.currentEndpoint != null ? this.currentEndpoint.toString() : "") + "; ");
        sb.append("currentRouteOffer=" + (this.currentRouteOffer != null ? this.currentRouteOffer.getFqName() : this.currentEndpoint.getRouteOffer() + "; "));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void resetIterator() {
        LOGGER.debug(null, "resetIterator", LogMessage.METHOD_ENTER);
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (DME2EndpointReference reference : this.staleEndpointReferences) {
            sb.append(delim).append(reference.getEndpoint().toURLString());
            delim = ", ";
        }
        FAILBACK_LOGGER.debug((URI)null, "remove", LogMessage.SEP_FAILBACK, (Object)sb.toString());
        this.staleEndpointReferences.clear();
        this.removedEndpointReferences.clear();
        this.currentEndpointListIndexPosition = -1;
        this.staleEndpointListIndexPosition = -1;
        this.orderedEndpointHolders = new ArrayList<DME2EndpointReference>(this.originalOrderedEndpointHolders);
        LOGGER.debug(null, "resetIterator", LogMessage.METHOD_EXIT);
    }

    @Override
    public int getTotalNumberOfElements() {
        return this.originalOrderedEndpointHolders.size();
    }

    @Override
    public int getNumberOfActiveElements() {
        return this.orderedEndpointHolders.size();
    }

    @Override
    public int getNumberOfStaleElements() {
        return this.staleEndpointReferences.size();
    }

    @Override
    public int getNumberOfRemovedElements() {
        return this.removedEndpointReferences.size();
    }

    @Override
    public int getCurrentIteratorActiveIndexPosition() {
        return this.currentEndpointListIndexPosition;
    }

    @Override
    public int getCurrentIteratorStaleIndexPosition() {
        return this.staleEndpointListIndexPosition;
    }

    @Override
    public String getCurrentDME2Endpoint() {
        return this.currentEndpoint.toString();
    }

    @Override
    public double getCurrentDME2EndpointDistanceBand() {
        return this.currentDistanceBand;
    }

    @Override
    public int getCurrentDME2EndpointSequence() {
        return this.currentSequence;
    }

    @Override
    public String getCurrentDME2EndpointRouteOffer() {
        return this.currentRouteOffer != null ? (this.currentRouteOffer.getRouteOffer() != null ? this.currentRouteOffer.getRouteOffer().getName() : null) : null;
    }

    @Override
    public void removeAllStaleIteratorElements() {
        this.manager.getStaleCache().clearStaleEndpoints();
    }

    @Override
    public void removeStaleIteratorElement(String serviceName) {
        this.manager.removeStaleEndpoint(serviceName);
    }

    @Override
    public boolean isAllElementsStale() {
        return this.originalOrderedEndpointHolders.size() == this.staleEndpointReferences.size();
    }

    @Override
    public boolean isAllElementsExhausted() {
        return !this.hasNext();
    }

    @Override
    public DME2RouteOffer getCurrentDME2RouteOffer() {
        return this.currentRouteOffer;
    }

    @Override
    public void setStale() {
        StaleProcessor.setStale(this.currentEndpointHolder.getRouteOffer(), this.manager, this.currentEndpointHolder.getEndpoint());
    }

    @Override
    public boolean isStale() {
        return StaleProcessor.isStale(this.manager, this.currentEndpointHolder.getEndpoint());
    }

    @Override
    public List<DME2EndpointReference> getEndpointReferenceList() {
        return this.orderedEndpointHolders;
    }

    @Override
    public int getMinActiveEndPoints() {
        return this.minActiveEndPoints;
    }

    @Override
    public DME2Manager getManager() {
        return this.manager;
    }

    @Override
    public DME2EndpointReference getCurrentEndpointReference() {
        return this.currentEndpointHolder;
    }
}

