/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.domain;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import java.net.URI;

public class DME2EndpointReference {
    private static final Logger logger = LoggerFactory.getLogger(DME2EndpointReference.class.getName());
    private DME2Manager manager;
    private DME2Endpoint endpoint;
    private DME2RouteOffer routeOffer;
    private Integer sequence;
    private Double distanceBand;

    public DME2Manager getManager() {
        return this.manager;
    }

    public DME2EndpointReference(DME2Manager manager, DME2Endpoint endpoint) {
        this.manager = manager;
        this.endpoint = endpoint;
    }

    public DME2EndpointReference setManager(DME2Manager manager) {
        this.manager = manager;
        return this;
    }

    public DME2Endpoint getEndpoint() {
        return this.endpoint;
    }

    public DME2EndpointReference setEndpoint(DME2Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public DME2RouteOffer getRouteOffer() {
        return this.routeOffer;
    }

    public DME2EndpointReference setRouteOffer(DME2RouteOffer routeOffer) {
        this.routeOffer = routeOffer;
        return this;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public DME2EndpointReference setSequence(Integer sequence) {
        this.sequence = sequence;
        return this;
    }

    public Double getDistanceBand() {
        return this.distanceBand;
    }

    public DME2EndpointReference setDistanceBand(Double distanceBand) {
        this.distanceBand = distanceBand;
        return this;
    }

    public DME2EndpointReference() {
    }

    public boolean isStale() {
        return this.manager.isUrlInStaleList(this.endpoint.getServiceEndpointID());
    }

    public void setStale() {
        Long stalenessDuration = 0L;
        if (this.routeOffer != null && this.routeOffer.getRouteOffer() != null && (stalenessDuration = this.routeOffer.getRouteOffer().getStalenessInMins()) != null) {
            stalenessDuration = stalenessDuration * 60000L;
        }
        String msg = String.format("Marking Endpoint %s stale.", this.endpoint.getServiceEndpointID());
        logger.debug((URI)null, "setStale", LogMessage.DEBUG_MESSAGE, (Object)msg);
        this.manager.addStaleEndpoint(this.endpoint.getServiceEndpointID(), stalenessDuration != null ? stalenessDuration : 0L);
    }
}

