/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.handler.order;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.iterator.helper.EndpointPreference;
import com.att.aft.dme2.iterator.service.DME2EndpointURLFormatter;
import com.att.aft.dme2.iterator.service.IteratorEndpointOrderHandler;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import java.net.URI;
import java.util.Map;

public class EndpointPreferredUrlOrderHandler
implements IteratorEndpointOrderHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointPreferredUrlOrderHandler.class.getName());
    private String preferredURL = null;
    private DME2EndpointURLFormatter urlFormatter = null;

    public EndpointPreferredUrlOrderHandler(String preferredURL, DME2EndpointURLFormatter urlFormatter) {
        this.urlFormatter = urlFormatter;
        this.preferredURL = preferredURL;
    }

    @Override
    public Map<Integer, Map<Double, DME2Endpoint[]>> order(Map<Integer, Map<Double, DME2Endpoint[]>> orderedEndpointByRouteOfferSeqMap) throws DME2Exception {
        LOGGER.info(null, "order", "start");
        long startTime = System.currentTimeMillis();
        LOGGER.info((URI)null, "order", "get endpoint map: {}", (Object)orderedEndpointByRouteOfferSeqMap);
        LOGGER.info((URI)null, "order", "resolvePreferredConnection:{}", (Object)this.preferredURL);
        if (orderedEndpointByRouteOfferSeqMap != null) {
            orderedEndpointByRouteOfferSeqMap = EndpointPreference.organizeEndpointsByPreferredURL(orderedEndpointByRouteOfferSeqMap, this.getPreferredUrl(), this.getUrlFormatter());
        }
        LOGGER.info((URI)null, "orderRouteOffers", "end;elapsed time:{}", (Object)(System.currentTimeMillis() - startTime));
        return orderedEndpointByRouteOfferSeqMap;
    }

    protected String getPreferredUrl() {
        return this.preferredURL;
    }

    protected DME2EndpointURLFormatter getUrlFormatter() {
        return this.urlFormatter;
    }
}

