/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.helper;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.iterator.dme2.DME2JdbcEndpoint;
import com.att.aft.dme2.iterator.service.DME2EndpointURLFormatter;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EndpointPreference {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointPreference.class.getName());

    private EndpointPreference() {
    }

    public static String resolvePreferredRouteOffer(DME2Configuration config, Properties props) {
        String preferredRouteOffer = null;
        if (props != null && (preferredRouteOffer = props.getProperty("AFT_DME2_PREFERRED_ROUTEOFFER")) != null) {
            return preferredRouteOffer;
        }
        preferredRouteOffer = config.getProperty("AFT_DME2_PREFERRED_ROUTEOFFER");
        return preferredRouteOffer;
    }

    public static String resolvePreferredConnection(DME2Configuration config, Properties props) {
        LOGGER.debug(null, "resolvePreferredConnection", "start");
        String preferredURL = null;
        if (props != null && (preferredURL = props.getProperty("AFT_DME2_PREFERRED_URL")) != null) {
            return preferredURL;
        }
        preferredURL = config.getProperty("AFT_DME2_PREFERRED_URL");
        return preferredURL;
    }

    public static void organizeByPreferredRouteOffer(Map<Integer, Map<Double, DME2Endpoint[]>> endpointsGrpBySeqDistMap, String preferredRouteOffer) {
        LOGGER.debug((URI)null, "organizeByPreferredRouteOffer", "Preferred routeOffer found! Reorganizing endpoints based on the following preferred routeOffer: {}", (Object)preferredRouteOffer);
        ArrayList<DME2Endpoint> preferredEndpoints = new ArrayList<DME2Endpoint>();
        Set<Integer> sequences = endpointsGrpBySeqDistMap.keySet();
        for (Integer sequence : sequences) {
            Map<Double, DME2Endpoint[]> distanceBandsToEndpointsMap = endpointsGrpBySeqDistMap.get(sequence);
            Set<Double> distanceBands = distanceBandsToEndpointsMap.keySet();
            for (Double distanceBand : distanceBands) {
                DME2Endpoint[] eps;
                for (DME2Endpoint ep : eps = distanceBandsToEndpointsMap.get(distanceBand)) {
                    if (!ep.getRouteOffer().equals(preferredRouteOffer)) continue;
                    preferredEndpoints.add(ep);
                }
            }
        }
        if (!preferredEndpoints.isEmpty()) {
            HashMap<Double, DME2Endpoint[]> preferredEndpointsMap = new HashMap<Double, DME2Endpoint[]>();
            DME2Endpoint[] preferredEndpointArray = new DME2Endpoint[preferredEndpoints.size()];
            preferredEndpoints.toArray(preferredEndpointArray);
            preferredEndpointsMap.put(0.0, preferredEndpointArray);
            endpointsGrpBySeqDistMap.put(-1, preferredEndpointsMap);
        }
    }

    public static Map<Integer, Map<Double, DME2Endpoint[]>> organizeEndpointsByPreferredURL(Map<Integer, Map<Double, DME2Endpoint[]>> endpointsGrpBySeqDistMap, String preferredURL, DME2EndpointURLFormatter urlFormatter) {
        DME2Endpoint endpointWithPreferredURL = null;
        boolean preferredURLFound = false;
        if (endpointsGrpBySeqDistMap != null) {
            Set<Integer> sequences = endpointsGrpBySeqDistMap.keySet();
            for (Integer sequence : sequences) {
                Map<Double, DME2Endpoint[]> distanceBandsToEndpoints = endpointsGrpBySeqDistMap.get(sequence);
                Set<Double> distanceBands = distanceBandsToEndpoints.keySet();
                for (Double distanceBand : distanceBands) {
                    DME2Endpoint[] eps;
                    for (DME2Endpoint ep : eps = distanceBandsToEndpoints.get(distanceBand)) {
                        String finalURLString = null;
                        if (urlFormatter != null) {
                            finalURLString = urlFormatter.formatURL(ep);
                            if (ep instanceof DME2JdbcEndpoint && finalURLString.startsWith("jdbc:dme2jdbc")) {
                                finalURLString = finalURLString.substring(9);
                            }
                        } else {
                            finalURLString = ep.toURLString();
                        }
                        if (!finalURLString.equals(preferredURL)) continue;
                        endpointWithPreferredURL = ep;
                        preferredURLFound = true;
                        break;
                    }
                    if (!preferredURLFound) continue;
                    break;
                }
                if (!preferredURLFound) continue;
                break;
            }
            if (preferredURLFound && endpointWithPreferredURL != null) {
                DME2Endpoint[] endpointArray = new DME2Endpoint[]{endpointWithPreferredURL};
                HashMap<Double, DME2Endpoint[]> map = new HashMap<Double, DME2Endpoint[]>();
                map.put(0.0, endpointArray);
                endpointsGrpBySeqDistMap.put(-1, map);
            }
        }
        return endpointsGrpBySeqDistMap;
    }
}

