/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.helper;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;

public class EndpointsByDistance {
    public static DME2Endpoint[][] organize(DME2Manager manager, DME2Endpoint[] eps) {
        HashMap bandLists = new HashMap();
        double[] bands = manager.getDistanceBands();
        for (int i = 0; i < bands.length; ++i) {
            bandLists.put(i, new ArrayList());
        }
        block1: for (DME2Endpoint ep : eps) {
            double distance = ep.getDistance();
            for (int i = 0; i < bands.length; ++i) {
                if (!(distance < bands[i])) continue;
                ((List)bandLists.get(i)).add(ep);
                continue block1;
            }
        }
        DME2Endpoint[][] bandedEps = new DME2Endpoint[bands.length][0];
        int counter = 0;
        for (List list : bandLists.values()) {
            Collections.shuffle(list);
            bandedEps[counter] = list.toArray(new DME2Endpoint[list.size()]);
            ++counter;
        }
        return bandedEps;
    }

    public static Map<Double, DME2Endpoint[]> organize(DME2Endpoint[] endpoints) throws DME2Exception {
        return EndpointsByDistance.organize(endpoints, new DME2Manager());
    }

    public static SortedMap<Integer, Map<Double, DME2Endpoint[]>> organize(SortedMap<Integer, DME2Endpoint[]> unorderedEndpointByRouteOfferSeqMap, DME2Manager manager) throws DME2Exception {
        TreeMap<Integer, Map<Double, DME2Endpoint[]>> endpointsGroupedBySequence = new TreeMap<Integer, Map<Double, DME2Endpoint[]>>();
        double[] distanceBands = manager.getDistanceBands();
        for (Map.Entry<Integer, DME2Endpoint[]> entry : unorderedEndpointByRouteOfferSeqMap.entrySet()) {
            endpointsGroupedBySequence.put(entry.getKey(), EndpointsByDistance.organize(manager, entry.getValue(), distanceBands));
        }
        return endpointsGroupedBySequence;
    }

    public static Map<Double, DME2Endpoint[]> organize(DME2Endpoint[] endpoints, DME2Manager manager) throws DME2Exception {
        return EndpointsByDistance.organize(manager, endpoints, manager.getDistanceBands());
    }

    public static Map<Double, DME2Endpoint[]> organize(DME2Manager manager, DME2Endpoint[] endpoints, double[] distanceBands) throws DME2Exception {
        TreeMap bandToEndpointMap = new TreeMap();
        TreeMap<Double, DME2Endpoint[]> map = new TreeMap<Double, DME2Endpoint[]>();
        for (double distanceBand : distanceBands) {
            bandToEndpointMap.put(distanceBand, new ArrayList());
        }
        block1: for (double endpoint : (Object)endpoints) {
            double endpointDistance = endpoint.getDistance();
            for (Double band : bandToEndpointMap.keySet()) {
                if (!(endpointDistance < band)) continue;
                ((List)bandToEndpointMap.get(band)).add(endpoint);
                continue block1;
            }
        }
        Object object = bandToEndpointMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            double band = (Double)entry.getKey();
            List endpointListUnshuffled = (List)entry.getValue();
            if (endpointListUnshuffled.size() <= 0) continue;
            List<DME2Endpoint> endpointList = EndpointsByDistance.randomizeEndpoints(endpointListUnshuffled);
            DME2Endpoint[] endpointArray = endpointList.toArray(new DME2Endpoint[endpointList.size()]);
            map.put(band, endpointArray);
        }
        return map;
    }

    private static List<DME2Endpoint> randomizeEndpoints(List<DME2Endpoint> endpoints) {
        Random random = new Random();
        ArrayList<DME2Endpoint> newList = new ArrayList<DME2Endpoint>();
        newList.addAll(endpoints);
        Collections.shuffle(newList, random);
        return newList;
    }
}

