/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.helper;

import com.att.aft.dme2.internal.google.common.base.Function;
import com.att.aft.dme2.internal.google.common.collect.ArrayListMultimap;
import com.att.aft.dme2.internal.google.common.collect.ListMultimap;
import com.att.aft.dme2.internal.google.common.collect.Multimaps;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RouteOfferOrganize {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteOfferOrganize.class.getName());

    private RouteOfferOrganize() {
    }

    public static ListMultimap<Integer, DME2RouteOffer> withSequence(List<DME2RouteOffer> routeOffers) {
        Function<DME2RouteOffer, Integer> keyFun = new Function<DME2RouteOffer, Integer>(){

            @Override
            public Integer apply(DME2RouteOffer routeOfferHolder) {
                return routeOfferHolder.getSequence();
            }
        };
        return ArrayListMultimap.create(Multimaps.index(routeOffers, keyFun));
    }

    public static ListMultimap<Integer, DME2RouteOffer> pushPreferredToFront(ListMultimap<Integer, DME2RouteOffer> routeOffersGrpBySeq, String preferredRouteOffer) {
        Set sequences = routeOffersGrpBySeq.keySet();
        if (preferredRouteOffer != null && routeOffersGrpBySeq != null && routeOffersGrpBySeq.size() > 1) {
            for (Integer sequence : sequences) {
                List<DME2RouteOffer> routeOfferList = routeOffersGrpBySeq.get(sequence);
                for (DME2RouteOffer routeOffer : routeOfferList) {
                    if (!routeOffer.getSearchFilter().contains(preferredRouteOffer)) continue;
                    routeOffersGrpBySeq.put(-1, routeOffer);
                    return routeOffersGrpBySeq;
                }
            }
        }
        LOGGER.info((URI)null, "containsPreferredRouteOffer", "cannot find preferred route offer: [{}], {}", (Object)preferredRouteOffer, (Object)routeOffersGrpBySeq);
        return routeOffersGrpBySeq;
    }

    public static Map<Integer, Map<Double, DME2Endpoint[]>> pushEndpointToFrontBasedOnPreferredRouteOffer(Map<Integer, Map<Double, DME2Endpoint[]>> endpointGroupByRouteOfferSequenceMap, String preferredRouteOffer) {
        if (preferredRouteOffer != null && endpointGroupByRouteOfferSequenceMap != null) {
            ArrayList<DME2Endpoint> preferredEndpointsList = new ArrayList<DME2Endpoint>();
            Set<Integer> sequences = endpointGroupByRouteOfferSequenceMap.keySet();
            for (Integer sequence : sequences) {
                Map<Double, DME2Endpoint[]> distanceBandsToEndpoints = endpointGroupByRouteOfferSequenceMap.get(sequence);
                Set<Double> distanceBands = distanceBandsToEndpoints.keySet();
                for (Double distanceBand : distanceBands) {
                    DME2Endpoint[] eps;
                    for (DME2Endpoint ep : eps = distanceBandsToEndpoints.get(distanceBand)) {
                        if (!ep.getRouteOffer().equals(preferredRouteOffer)) continue;
                        preferredEndpointsList.add(ep);
                    }
                }
            }
            if (!preferredEndpointsList.isEmpty()) {
                HashMap<Double, DME2Endpoint[]> preferredEndpointsMap = new HashMap<Double, DME2Endpoint[]>();
                DME2Endpoint[] preferredEndpointArray = new DME2Endpoint[preferredEndpointsList.size()];
                preferredEndpointsList.toArray(preferredEndpointArray);
                preferredEndpointsMap.put(0.0, preferredEndpointArray);
                endpointGroupByRouteOfferSequenceMap.put(-1, preferredEndpointsMap);
            }
        }
        LOGGER.info((URI)null, "containsPreferredRouteOffer", "cannot find preferred route offer: [{}], {}", (Object)preferredRouteOffer, (Object)endpointGroupByRouteOfferSequenceMap);
        return endpointGroupByRouteOfferSequenceMap;
    }
}

