/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.helper;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2URIUtils;
import java.net.URI;

public class StaleProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaleProcessor.class.getName());

    private StaleProcessor() {
    }

    public static boolean containsStaleRouteOffer(DME2Configuration config, DME2RouteOffer offer, DME2Manager manager) {
        String[] routeOffers;
        LOGGER.debug((URI)null, "containsStaleRouteOffer", "start; checking for stale RouteOffers using search filter: {}", (Object)offer.getSearchFilter());
        int staleCount = 0;
        for (String routeOffer : routeOffers = offer.getSearchFilter().split(config.getProperty("DME2_RO_SEP"))) {
            String serviceURI = null;
            if (routeOffer.equals(DmeUniformResource.DmeUrlType.DIRECT.toString()) || !manager.isRouteOfferStale(serviceURI = DME2URIUtils.buildServiceURIString(offer.getService(), offer.getVersion(), offer.getEnvContext(), routeOffer))) continue;
            ++staleCount;
        }
        if (staleCount == routeOffers.length) {
            LOGGER.debug((URI)null, "containsStaleRouteOffer", "All RouteOffers for service {} were previously marked stale. The number of RouteOffers in the search filter was: {}.", (Object)offer.getService(), (Object)routeOffers.length);
            return true;
        }
        return false;
    }

    public static boolean isStale(DME2Manager manager, DME2Endpoint endpoint) {
        return manager.isUrlInStaleList(endpoint.getServiceEndpointID());
    }

    public static void setStale(DME2RouteOffer orderedRouteOffer, DME2Manager manager, DME2Endpoint endpoint) {
        Long stalenessDuration = 0L;
        if (orderedRouteOffer != null && orderedRouteOffer.getRouteOffer() != null && (stalenessDuration = orderedRouteOffer.getRouteOffer().getStalenessInMins()) != null) {
            stalenessDuration = stalenessDuration * 60000L;
        }
        LOGGER.debug((URI)null, "setStale", "Marking Endpoint [{}] stale.", (Object)endpoint.getServiceEndpointID());
        manager.addStaleEndpoint(endpoint.getServiceEndpointID(), stalenessDuration != null ? stalenessDuration : 0L);
    }
}

