/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jaxws.client;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class DME2SOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    private String handlerName = null;
    private DME2Manager manager = null;

    public void setHandlerName(String name) {
        this.handlerName = name;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    @PostConstruct
    public synchronized void init() {
        try {
            if (this.manager == null) {
                this.manager = DME2Manager.getDefaultInstance();
            }
        }
        catch (DME2Exception e) {
            throw new RuntimeException(DME2SOAPHandler.class.getName() + " init() failed with extended exception message: " + e.toString(), e);
        }
    }

    @PreDestroy
    public void destroy() {
    }

    public Set<QName> getHeaders() {
        return new TreeSet<QName>();
    }

    public boolean handleMessage(SOAPMessageContext context) {
        URI uri;
        Long readTimeoutMs;
        if (this.manager == null) {
            this.init();
        }
        boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        String uriString = (String)context.get((Object)"com.att.aft.dme2.jaxws.client.uri");
        if (uriString == null) {
            uriString = (String)context.get((Object)"javax.xml.ws.service.endpoint.address");
        }
        if (uriString == null) {
            throw new RuntimeException("DME2SOAPHandler required context property com.att.aft.dme2.jaxws.client.uri to be set");
        }
        Long connTimeoutMs = (Long)context.get((Object)"com.att.aft.dme2.jaxws.client.connTimeoutMs");
        if (connTimeoutMs == null) {
            connTimeoutMs = 4000L;
        }
        if ((readTimeoutMs = (Long)context.get((Object)"com.att.aft.dme2.jaxws.client.readTimeoutMs")) == null) {
            readTimeoutMs = 30000L;
        }
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException("DME2SOAPHandler retrieved uri [" + uriString + "] from com.att.aft.dme2.jaxws.client.uri, but it is not in a valid format: " + e1.toString(), e1);
        }
        if (outbound) {
            SOAPMessage soapMessage = context.getMessage();
            try {
                DME2Client client = this.manager.newClient(uri, connTimeoutMs);
                client.setMethod("POST");
                client.setPayload(this.convertSOAPMessageToString(soapMessage));
                String response = client.sendAndWait(readTimeoutMs);
                context.setMessage(this.convertStringToSOAPMessage(response));
            }
            catch (SOAPException e) {
                throw new ProtocolException("Failure during call to remote service: " + e.toString(), (Throwable)e);
            }
            catch (Exception e) {
                throw new ProtocolException(e.toString(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        if (this.manager == null) {
            this.init();
        }
        return true;
    }

    public void close(MessageContext context) {
    }

    private String convertSOAPMessageToString(SOAPMessage message) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            return baos.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert SOAPMessage to payload stream because: " + e.toString(), e);
        }
    }

    private SOAPMessage convertStringToSOAPMessage(String soapText) {
        try {
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPMessage message = msgFactory.createMessage();
            SOAPPart soapPart = message.getSOAPPart();
            byte[] buffer = soapText.getBytes();
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
            StreamSource source = new StreamSource(stream);
            soapPart.setContent((Source)source);
            return message;
        }
        catch (Exception e) {
            throw new ProtocolException("Failed to convert incoming payload to a SOAPMessage because: " + e.toString(), (Throwable)e);
        }
    }
}

