/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSMessageConsumer;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSQueueConnection;
import com.att.aft.dme2.jms.DME2JMSQueueSession;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

public class DME2JMSConnectionConsumer
implements ConnectionConsumer,
MessageListener {
    private DME2JMSQueue destination;
    private ServerSessionPool sessionPool;
    private boolean open = true;
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSConnectionConsumer.class.getName());

    public DME2JMSConnectionConsumer(DME2JMSQueueConnection connection, DME2JMSQueue destination, String messageSelector, ServerSessionPool sessionPool, DME2JMSMessageConsumer bridge) throws JMSException {
        this.destination = destination;
        this.sessionPool = sessionPool;
        this.destination.addListener(bridge, this, messageSelector);
    }

    public void close() throws JMSException {
        this.open = false;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        if (!this.open) {
            throw new DME2JMSException("AFT-DME2-5001", new ErrorContext());
        }
        return this.sessionPool;
    }

    public void onMessage(Message m) {
        try {
            ServerSession serverSession = this.sessionPool.getServerSession();
            if (serverSession == null) {
                logger.debug((URI)null, "onMessage", "AFT-DME2-5002", (Object)new ErrorContext());
                return;
            }
            Session s = serverSession.getSession();
            if (s instanceof DME2JMSQueueSession) {
                DME2JMSQueueSession s2 = (DME2JMSQueueSession)s;
                MessageListener l = s2.getMessageListener();
                if (l == null) {
                    logger.debug((URI)null, "onMessage", "AFT-DME2-5003", (Object)new ErrorContext());
                    return;
                }
                ((DME2JMSQueueSession)s).setDistinquishedMessage(m);
                serverSession.start();
            }
        }
        catch (JMSException e) {
            logger.error((URI)null, "onMessage", "AFT-DME2-5004", (Object)new ErrorContext(), (Object)e);
        }
    }
}

