/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSQueueConnectionFactory;
import com.att.aft.dme2.jms.DME2JMSTopicConnectionFactory;
import com.att.aft.dme2.jms.DME2JMSXAQueueConnectionFactory;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DME2JMSInitialContext
extends InitialContext {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSInitialContext.class.getName());
    private transient DME2Manager manager;
    private transient DME2JMSManager jmsManager;
    private Map<String, DME2JMSManager> instances = new HashMap<String, DME2JMSManager>();

    public DME2JMSInitialContext(Hashtable<?, ?> environment) throws NamingException {
        DME2JMSManager instance;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)environment);
        String dme2ManagerName = props.getProperty("AFT_DME2_MANAGER_NAME");
        if (dme2ManagerName == null) {
            dme2ManagerName = props.getProperty("DME2_MANAGER_NAME");
        }
        if ((instance = this.instances.get(dme2ManagerName)) == null) {
            if (dme2ManagerName == null) {
                try {
                    this.jmsManager = DME2JMSManager.getDefaultInstance(props);
                }
                catch (JMSException e) {
                    throw new NamingException("[" + e.getErrorCode() + "] - DME2JMSInitialContext failed to load default DME2JMSManager - " + e.getMessage());
                }
                catch (Exception ex) {
                    throw new NamingException("[" + ex.getMessage() + "] - DME2JMSInitialContext failed to load default DME2JMSManager - " + ex.getMessage());
                }
            }
            try {
                ArrayList<String> defaultConfigs = new ArrayList<String>();
                defaultConfigs.add("jms-provider_defaultConfigs.properties");
                defaultConfigs.add("dme-api_defaultConfigs.properties");
                DME2Configuration config = new DME2Configuration(dme2ManagerName, defaultConfigs, null, props);
                this.manager = new DME2Manager(dme2ManagerName, config);
                this.jmsManager = new DME2JMSManager(this.manager);
            }
            catch (DME2Exception e) {
                throw new NamingException("[" + e.getErrorCode() + "] - DME2JMSInitialContext failed to load custom DME2Manager [" + dme2ManagerName + "] - " + e.getMessage());
            }
            this.manager = this.jmsManager.getDME2Manager();
            this.instances.put(this.manager.getName(), this.jmsManager);
            logger.debug((URI)null, "DME2JMSInitialContext", (LogMessage)JMSLogMessage.QUEUE_CREATED, (Object)this.manager.getName());
        }
    }

    @Override
    public Object lookup(String path) throws NamingException {
        logger.debug(null, "lookup", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "lookup", "Looking up [{}]", (Object)path);
        if (path == null || path.length() == 0) {
            return this;
        }
        try {
            if (path.startsWith("qcf://dme2")) {
                DME2JMSQueueConnectionFactory dME2JMSQueueConnectionFactory = this.jmsManager.getQCF(path);
                return dME2JMSQueueConnectionFactory;
            }
            if (path.startsWith("xaqcf://dme2")) {
                DME2JMSXAQueueConnectionFactory dME2JMSXAQueueConnectionFactory = this.jmsManager.getXAQCF(path);
                return dME2JMSXAQueueConnectionFactory;
            }
            if (path.startsWith("QCFDME2")) {
                DME2JMSQueueConnectionFactory dME2JMSQueueConnectionFactory = this.jmsManager.getQCF(path);
                return dME2JMSQueueConnectionFactory;
            }
            if (path.startsWith("tcf://dummy")) {
                DME2JMSTopicConnectionFactory dME2JMSTopicConnectionFactory = this.jmsManager.getDummyTCF(path);
                return dME2JMSTopicConnectionFactory;
            }
            DME2JMSQueue dME2JMSQueue = this.jmsManager.getQueue(path);
            return dME2JMSQueue;
        }
        catch (URISyntaxException e) {
            NamingException n = new NamingException(e.getMessage());
            n.initCause(e);
            throw n;
        }
        catch (JMSException e) {
            NamingException n = new NamingException(e.getMessage());
            n.initCause(e);
            throw n;
        }
        finally {
            logger.debug(null, "lookup", LogMessage.METHOD_EXIT);
        }
    }
}

