/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSErrorMessage;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSMessageConsumer;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSServiceHolder;
import com.att.aft.dme2.jms.DME2JMSServiceUnavailableException;
import com.att.aft.dme2.jms.DME2JMSServlet;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.jms.MessageArrivalProcessor;
import com.att.aft.dme2.jms.MessageListenerHolder;
import com.att.aft.dme2.jms.WaiterNotifier;
import com.att.aft.dme2.jms.util.DME2JNDIReferenceFactory;
import com.att.aft.dme2.jms.util.DME2JNDIStorableInterface;
import com.att.aft.dme2.jms.util.JMSConstants;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.servlet.Servlet;

public class DME2JMSLocalQueue
extends DME2JMSQueue
implements DME2JNDIStorableInterface,
Externalizable {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSLocalQueue.class.getName());
    private transient ThreadPoolExecutor threadpool = null;
    private static transient ThreadPoolExecutor tempQueueThreadpool = null;
    private static ThreadFactory tempQueueTFactory;
    private final int corePoolSize = 0;
    private final int maxPoolSize = 1;
    private static final int CONSTANT_TTL = 60000;
    private final long ttl = 60000L;
    private static final int CONSTANT_TEMPQUEUECOREPOOLSIZE = 50;
    private int tempQueueCorePoolSize = 50;
    private static final int CONSTANT_TEMPQUEUEMAXPOOLSIZE = 500;
    private int tempQueueMaxPoolSize = 500;
    private long tempQueueTtl = 60000L;
    private static final int CONSTANT_MAXPUTRETRY = 10;
    private int maxPutRetry = 10;
    private BlockingQueue<DME2JMSMessage> queueData = null;
    private final List<WaiterNotifier> waiters = Collections.synchronizedList(new ArrayList());
    private ThreadFactory tFactory;
    private boolean registered = false;
    private boolean opened = true;
    private transient DME2JMSManager manager;
    private boolean isTempQueue = false;
    private static final int CONSTANT_SERVERQDEPTH = 1;
    private static final int CONSTANT_CLIENTQDEPTH = 50;
    private int serverQDepth = 1;
    private int clientQDepth = 50;
    private static final int CONSTANT_AFT_DME2_MAX_RETRY = 10;
    private static final int CONSTANT_AFT_DME2_TEMPQ_TP_CORE = 50;
    private static final int CONSTANT_AFT_DME2_TEMPQ_TP_MAX = 500;
    private static byte[] lockObj;
    private DME2Configuration config;

    public DME2JMSLocalQueue() throws JMSException {
        super(null, null);
        logger.debug(null, "DME2JMSLocalQueue", "LocalQueue default constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected DME2JMSLocalQueue(DME2JMSManager manager, URI name, boolean isTempQueue) throws JMSException {
        super(manager, name);
        this.isTempQueue = isTempQueue;
        logger.debug((URI)null, "DME2JMSLocalQueue", "LocalQueue args constructor; QueueMgr name={}; isTempQueue={}", (Object)manager.getDME2Manager().getName(), (Object)isTempQueue);
        try {
            this.manager = manager;
            this.config = manager.getDME2Manager().getConfig();
            this.maxPutRetry = this.config.getInt(JMSConstants.AFT_DME2_MAX_RETRY);
        }
        catch (Exception e) {
            this.maxPutRetry = 10;
        }
        logger.debug((URI)null, "DME2JMSLocalQueue", "value of AFT_DME2_SERVER_QDEPTH is: {}", (Object)this.config.getInt(JMSConstants.AFT_DME2_SERVER_QDEPTH));
        this.serverQDepth = this.config.getInt(JMSConstants.AFT_DME2_SERVER_QDEPTH, 1);
        this.clientQDepth = this.config.getInt(JMSConstants.AFT_DME2_CLIENT_QDEPTH, 50);
        this.tempQueueCorePoolSize = this.config.getInt(JMSConstants.AFT_DME2_TEMPQ_TP_CORE, 50);
        this.tempQueueMaxPoolSize = this.config.getInt(JMSConstants.AFT_DME2_TEMPQ_TP_MAX, 500);
        this.tempQueueTtl = this.config.getInt(JMSConstants.AFT_DME2_TEMPQ_TP_TTL);
        this.queueData = this.isClient() ? new LinkedBlockingQueue<DME2JMSMessage>(this.clientQDepth) : new LinkedBlockingQueue<DME2JMSMessage>(this.serverQDepth);
        if (!isTempQueue) {
            this.tFactory = new ThreadFactory(){
                private int counter = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    String name = "";
                    try {
                        name = DME2JMSLocalQueue.this.getQueueName();
                    }
                    catch (Exception e) {
                        logger.debug((URI)null, "DME2JMSLocalQueue", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                    t.setName("DME2JMS::ListenerThread[" + name + "]-" + this.counter++);
                    return t;
                }
            };
            logger.debug(null, "DME2JMSLocalQueue", LogMessage.METHOD_ENTER);
            this.threadpool = new ThreadPoolExecutor(0, 1, 60000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), this.tFactory);
        } else if (tempQueueThreadpool == null) {
            byte[] byArray = lockObj;
            // MONITORENTER : lockObj
            if (tempQueueThreadpool == null) {
                tempQueueTFactory = new ThreadFactory(){
                    private int counter = 0;

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(r);
                        t.setName("DME2JMS::ListenerThread[TempQueue]-" + this.counter++);
                        return t;
                    }
                };
                tempQueueThreadpool = new ThreadPoolExecutor(this.tempQueueCorePoolSize, this.tempQueueMaxPoolSize, this.tempQueueTtl, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), tempQueueTFactory);
            }
            // MONITOREXIT : byArray
        }
        logger.debug((URI)null, "DME2JMSLocalQueue", "Created: {}", (Object)name);
        logger.debug(null, "DME2JMSLocalQueue", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message get(long timeout, String filter) throws JMSException {
        if (!this.isOpen()) {
            throw new DME2JMSException("AFT-DME2-5400", new ErrorContext());
        }
        logger.debug((URI)null, "get", LogMessage.METHOD_ENTER, (Object)this.getQueueName());
        DME2JMSMessage m = null;
        WaiterNotifier notifier = null;
        try {
            long startTime = System.currentTimeMillis();
            long waitTime = timeout;
            notifier = new WaiterNotifier(filter, this);
            Object object = this.waiters;
            synchronized (object) {
                this.waiters.add(notifier);
            }
            object = this.queueData;
            synchronized (object) {
                Iterator it = this.queueData.iterator();
                while (it.hasNext()) {
                    DME2JMSMessage candidate = (DME2JMSMessage)it.next();
                    if (candidate.isExpired()) {
                        it.remove();
                        continue;
                    }
                    if (filter != null && !candidate.matches(filter)) continue;
                    it.remove();
                    m = candidate;
                    break;
                }
            }
            if (m == null) {
                long elapsed = System.currentTimeMillis() - startTime;
                waitTime = timeout - elapsed;
                if (timeout == 0L) {
                    m = notifier.get(timeout);
                } else if (waitTime > 0L) {
                    m = notifier.get(waitTime);
                }
            }
            if (m != null) {
                Properties debugProps = m.getProperties();
                StringBuffer debugSB = new StringBuffer();
                Enumeration<?> e = debugProps.propertyNames();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object value = debugProps.get(key);
                    if (debugSB.length() > 1) {
                        debugSB.append(",");
                    }
                    debugSB.append(key);
                    debugSB.append("=");
                    debugSB.append(value);
                }
                logger.debug((URI)null, "get", "get: ", (Object)debugSB);
            }
            if (m instanceof DME2JMSErrorMessage) {
                DME2JMSErrorMessage em = (DME2JMSErrorMessage)m;
                if (em.isFastFailNull()) {
                    logger.warn((URI)null, "get", "get: ", new Object[]{"AFT-DME2-5408", new ErrorContext().add("extendedMessage", em.getJMSException().getMessage()).add("queue", this.getQueueName()).add("endpointsAttempted", em.getStringProperty("AFT_DME2_REQ_TRACE_INFO")).add("filter", filter), em.getJMSException()});
                    throw new DME2JMSException("AFT-DME2-5408", new ErrorContext().add("extendedMessage", em.getJMSException().getMessage()).add("queue", this.getQueueName()).add("endpointsAttempted", em.getStringProperty("AFT_DME2_REQ_TRACE_INFO")).add("filter", filter), (Throwable)em.getJMSException());
                }
                throw new DME2JMSException("AFT-DME2-5401", new ErrorContext().add("extendedMessage", em.getJMSException().getMessage()).add("queue", this.getQueueName()).add("filter", filter), (Throwable)em.getJMSException());
            }
            object = m;
            return object;
        }
        finally {
            if (notifier != null) {
                List<WaiterNotifier> list = this.waiters;
                synchronized (list) {
                    this.waiters.remove(notifier);
                }
            }
            logger.debug(null, "get", LogMessage.METHOD_EXIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(DME2JMSMessage m) throws JMSException {
        Object it;
        logger.debug((URI)null, "put", LogMessage.METHOD_ENTER, (Object)this.getQueueName());
        logger.debug((URI)null, "put", "LocalQueue JMSMessage put ", (Object)m.getJMSMessageID());
        boolean putDone = false;
        m.setJMSDestination((Destination)this);
        if (m.getJMSPriority() < 0) {
            m.setJMSPriority(super.getDefaultPriority());
        }
        if (m.getJMSDeliveryMode() != 1) {
            m.setJMSDeliveryMode(1);
        }
        if (m.getJMSExpiration() < 0L) {
            m.setJMSExpiration(System.currentTimeMillis() + super.getDefaultTtlMs());
        }
        if (this.waiters.size() > 0) {
            List<WaiterNotifier> list = this.waiters;
            synchronized (list) {
                it = this.waiters.iterator();
                while (it.hasNext()) {
                    WaiterNotifier waiter = it.next();
                    if (!waiter.matches(m)) continue;
                    if (waiter.notify(m)) {
                        it.remove();
                        putDone = true;
                        break;
                    }
                    this.retryWaiters(m);
                    break;
                }
            }
        }
        boolean isReceiveToService = m.getBooleanProperty("com.att.aft.dme2.jms.isReceiveToService");
        logger.debug(null, "put", "Queue put: isReceiveToService=" + isReceiveToService);
        if (!putDone && super.getListeners().size() == 0 && this.isClient()) {
            if (m.getJMSMessageID() == null) {
                m.genID();
            }
            it = this.queueData;
            synchronized (it) {
                logger.debug(null, "put", "Waiters size for queue {}|{}={}", this.getQueueName(), m.getJMSMessageID(), this.waiters.size());
                logger.debug((URI)null, "put", "LocalQueue JMSMessage queueData added {}", (Object)m.getJMSMessageID());
                try {
                    this.queueData.add(m);
                }
                catch (IllegalStateException e) {
                    throw new DME2JMSServiceUnavailableException("AFT-DME2-5409", new ErrorContext().add("queueName", this.getQueueName()).add("queueDepth", this.queueData.size() + ""), e);
                }
                putDone = true;
            }
        }
        if (!putDone) {
            if (!this.isTempQueue && this.threadpool.getMaximumPoolSize() == 1 && super.getListeners().size() == 0) {
                throw new DME2JMSServiceUnavailableException("AFT-DME2-5401", new ErrorContext().add("queueName", this.getQueueName()));
            }
            MessageListenerHolder holder = null;
            try {
                holder = this.checkoutListener(m);
                if (holder == null) {
                    DME2JMSServiceUnavailableException e = new DME2JMSServiceUnavailableException("AFT-DME2-5402", new ErrorContext().add("queueName", this.getQueueName()));
                    throw e;
                }
                if (!this.isTempQueue) {
                    this.threadpool.submit(new MessageArrivalProcessor(this, m, holder));
                } else {
                    tempQueueThreadpool.submit(new MessageArrivalProcessor(this, m, holder));
                }
                putDone = true;
            }
            catch (RejectedExecutionException e) {
                this.checkinHolder(holder);
                throw new DME2JMSServiceUnavailableException("AFT-DME2-5403", new ErrorContext().add("queueName", this.getQueueName()));
            }
            catch (Throwable th) {
                this.checkinHolder(holder);
                throw new DME2JMSServiceUnavailableException("AFT-DME2-5403", new ErrorContext().add("queueName", this.getQueueName()).add("errorOnListenerSubmit", "Exception on threadPool task submit"));
            }
            finally {
                if (!putDone) {
                    this.checkinHolder(holder);
                }
            }
        }
        if (putDone) {
            try {
                if (m instanceof DME2JMSTextMessage && !this.isClient()) {
                    DME2JMSTextMessage tm = (DME2JMSTextMessage)m;
                    long msgSize = tm.getText().length();
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("MSG_SIZE", msgSize);
                    props.put("EVENT_TIME", System.currentTimeMillis());
                    props.put("CREATE_TIME", this.getCreateTime());
                    props.put("REQUEST_EVENT", true);
                    props.put("QUEUE_NAME", this.getQueueName());
                    props.put("DME2_INTERFACE_PROTOCOL", this.config.getProperty("AFT_DME2_INTERFACE_JMS_PROTOCOL"));
                    if (m.getJMSCorrelationID() != null) {
                        props.put("MESSAGE_ID", m.getJMSCorrelationID());
                    } else {
                        props.put("MESSAGE_ID", m.getJMSMessageID());
                    }
                    this.manager.getDME2Manager().postStatEvent(props);
                }
            }
            catch (Exception e) {
                logger.debug((URI)null, "put", "AFT-DME2-5407", (Object)new ErrorContext().add("requestQueue", this.getQueueName()), (Object)e);
            }
        }
        logger.debug(null, "put", LogMessage.METHOD_EXIT);
    }

    @Override
    public synchronized void addListener(DME2JMSMessageConsumer consumer, MessageListener listener, String filter) throws JMSException {
        logger.debug(null, "addListener", LogMessage.METHOD_ENTER);
        super.addListener(consumer, listener, filter);
        if (super.getListeners().size() > 0 && !this.isTempQueue) {
            this.threadpool.setMaximumPoolSize(super.getListeners().size());
        }
        try {
            DME2Manager dm = this.manager.getDME2Manager();
            if (!this.registered && !this.isClient()) {
                logger.debug((URI)null, "addListener", "Binding jms servlet to Queue={}", (Object)this.getQueueName());
                DME2JMSServiceHolder serviceHolder = new DME2JMSServiceHolder(this);
                serviceHolder.setServiceURI(this.getQueueNameURI());
                serviceHolder.setServlet((Servlet)new DME2JMSServlet(this.manager));
                serviceHolder.setSecurityRealm(this.getRealmName());
                serviceHolder.setAllowedRoles(this.getAllowedRoles());
                serviceHolder.setLoginMethod(this.getLoginMethod());
                serviceHolder.setManager(dm);
                dm.bindService(serviceHolder);
                this.registered = true;
            }
        }
        catch (DME2Exception e) {
            throw new DME2JMSException("AFT-DME2-5403", new ErrorContext().add("queueName", this.getQueueName()), (Throwable)e);
        }
        if (listener != null) {
            logger.debug(null, "addListener", (LogMessage)JMSLogMessage.QUEUE_ADDLISTENER, this.getQueueName(), listener.getClass(), filter);
        }
        logger.debug(null, "addListener", LogMessage.METHOD_EXIT);
    }

    public void addMessageToQueue(DME2JMSMessage m) {
        this.queueData.add(m);
    }

    @Override
    public synchronized void removeListener(DME2JMSMessageConsumer consumer) throws JMSException {
        logger.debug(null, "removeListener", LogMessage.METHOD_ENTER);
        if (consumer != null) {
            logger.info(null, "removeListener", (LogMessage)JMSLogMessage.QUEUE_REMOVELISTNR, this.getQueueName(), consumer.getClass(), consumer.getMessageListener(), this.getListeners().size());
        }
        if (super.getListeners().size() > 1) {
            if (!this.isTempQueue) {
                this.threadpool.setMaximumPoolSize(super.getListeners().size() - 1);
            }
        } else {
            try {
                if (super.getListeners().size() <= 0 && !this.isClient()) {
                    this.manager.getDME2Manager().unbindServiceListener(this.getQueueName());
                    this.registered = false;
                }
            }
            catch (DME2Exception e) {
                throw new DME2JMSException("AFT-DME2-5404", new ErrorContext().add("queueName", this.getQueueName()), (Throwable)e);
            }
        }
        super.removeListener(consumer);
        logger.debug(null, "removeListener", LogMessage.METHOD_EXIT);
    }

    @Override
    public synchronized void removeListener(DME2JMSMessageConsumer consumer, MessageListener listener) throws JMSException {
        logger.debug(null, "removeListener", LogMessage.METHOD_ENTER);
        if (super.getListeners().size() > 1) {
            if (!this.isTempQueue) {
                this.threadpool.setMaximumPoolSize(super.getListeners().size() - 1);
            }
        } else {
            try {
                if (super.getListeners().size() <= 0 && !this.isClient()) {
                    this.manager.getDME2Manager().unbindServiceListener(this.getQueueName());
                }
            }
            catch (DME2Exception e) {
                throw new DME2JMSException("AFT-DME2-5405", new ErrorContext().add("queueName", this.getQueueName()), (Throwable)e);
            }
        }
        super.removeListener(consumer, listener);
        logger.debug(null, "removeListener", LogMessage.METHOD_EXIT);
    }

    public String toString() {
        try {
            return "LocalQueue: " + this.getQueueName();
        }
        catch (JMSException e) {
            return "LocalQueue";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retryWaiters(DME2JMSMessage m) throws DME2JMSServiceUnavailableException, JMSException {
        boolean putDone = false;
        for (int i = 0; i < this.maxPutRetry; ++i) {
            List<WaiterNotifier> list = this.waiters;
            synchronized (list) {
                Iterator<WaiterNotifier> it = this.waiters.iterator();
                while (it.hasNext()) {
                    WaiterNotifier waiter = it.next();
                    if (!waiter.matches(m) || !waiter.notify(m)) continue;
                    it.remove();
                    putDone = true;
                    logger.info((URI)null, "retryWaiters", "Code=Server.Retry.NoWaiters;RetryAttempt={}", (Object)i);
                    break;
                }
            }
            if (putDone) break;
        }
        if (!putDone) {
            throw new DME2JMSServiceUnavailableException("AFT-DME2-5406", new ErrorContext().add("requestQueue", this.getQueueName()));
        }
        return putDone;
    }

    protected boolean isOpen() {
        return this.opened;
    }

    protected void close() {
        this.opened = false;
    }

    @Override
    public void setProperties(Properties props) {
        this.buildFromProperties(props);
    }

    @Override
    public Properties getProperties() {
        return null;
    }

    public void buildFromProperties(Properties props) {
    }

    public void populateProperties(Properties props) {
    }

    @Override
    public Reference getReference() throws NamingException {
        return DME2JNDIReferenceFactory.createReference(this.getClass().getName(), this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Properties props = (Properties)in.readObject();
        if (props != null) {
            this.setProperties(props);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getProperties());
    }

    private void checkinHolder(MessageListenerHolder holder) {
        if (holder != null && !holder.isReceiver()) {
            holder.checkin();
        }
    }

    static {
        lockObj = new byte[0];
    }
}

